package com.freemud.framework.versionctl.proxy;

import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import com.freemud.framework.versionctl.VersionException;
import com.freemud.framework.versionctl.annos.BeanVersion;

import java.util.HashMap;
import java.util.Map;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: VersionBeansFactory
 * @Package cn.framework.versionctl
 * @Description:
 * @author: dingshaocheng
 * @date: 2018/4/21
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
@Service
public class VersionBeansFactory<T> implements FactoryBean<T> {

    @Autowired
    private VersionBeanProxy versionBeanProxy;
    private HashMap<String,Object> versionBeans = new HashMap<>();

    @Autowired
    private DefaultListableBeanFactory defaultListableBeanFactory;

    /**
     * 服务接口类名.
     */
    private String productClassName;

    public void setProductClassName(final String productClassName) {
        this.productClassName = productClassName;
        Map<String, ?> beansOfType = defaultListableBeanFactory.getBeansOfType(getObjectType());
        beansOfType.entrySet().forEach(b->{
            T instance = (T) b.getValue();
            final BeanVersion version = instance.getClass().getAnnotation(BeanVersion.class);
            String versionStr = "";
            if(version != null){
                versionStr = version.value();
            }
            if(versionBeans.containsKey(versionStr)){
                throw new VersionException("同一版本的同一个类不允许有多个实现");
            }
            versionBeans.put(versionStr,instance);
            defaultListableBeanFactory.removeBeanDefinition(b.getKey());
        });

    }
    @Override
    public T getObject() throws Exception {
        final Object target = versionBeanProxy
                .getInstance(versionBeans,getObjectType());

        return (T) target;
    }

    @Override
    public Class<?> getObjectType() {
        if (StringUtils.isEmpty(productClassName)) {
            return null;
        }

        try {
            return Class.forName(productClassName);
        } catch (final Exception e) {
            throw new VersionException("Load VersionCtl service class [" + productClassName + "]");
        }
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}
