package com.freemud.framework.versionctl.boot;

import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.filter.AnnotationTypeFilter;

import com.freemud.framework.versionctl.annos.VersionCtl;
import com.freemud.framework.versionctl.proxy.VersionBeansFactory;

import java.util.Set;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: VersionCtlServiceScanner
 * @Package cn.framework.versionctl
 * @Description:
 * @author: dingshaocheng
 * @date: 2018/4/21
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
public class VersionCtlServiceScanner extends ClassPathBeanDefinitionScanner {
    public VersionCtlServiceScanner(BeanDefinitionRegistry registry) {
        super(registry);
    }
    @Override
    public void registerDefaultFilters() {
        // BeanVersion 注解都作为候选 bean
        addIncludeFilter(new AnnotationTypeFilter(VersionCtl.class));
    }
    @Override
    protected Set<BeanDefinitionHolder> doScan(String... basePackages) {
        final Set<BeanDefinitionHolder> ret = super.doScan(basePackages);
        for (final BeanDefinitionHolder holder : ret) {
            final BeanDefinition beanDefinition = holder.getBeanDefinition();
            if (beanDefinition.getBeanClassName().endsWith("package-info")) {
                continue;
            }

            final GenericBeanDefinition beanDef =  (GenericBeanDefinition)beanDefinition;
            // 注入服务消费者类名
            beanDef.getPropertyValues().add("productClassName", beanDef.getBeanClassName());
            //FactoryBean<T>
            beanDef.setBeanClass(VersionBeansFactory.class);
        }

        return ret;
    }

    @Override
    public boolean isCandidateComponent(final AnnotatedBeanDefinition beanDefinition) {
        return true;
    }
}
