package com.freemud.framework.versionctl.boot;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.MultiValueMap;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import com.freemud.framework.spring.AppContext;
import com.freemud.framework.versionctl.VersionException;
import com.freemud.framework.versionctl.annos.EnableVersionCtl;
import com.freemud.framework.versionctl.proxy.DefaultVersionBeanFactory;
import com.freemud.framework.versionctl.proxy.VersionGetter;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: VersionCtlAutoLoad
 * @Package cn.framework.versionctl.boot
 * @Description:
 * @author: dingshaocheng
 * @date: 2018/4/21
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
@Configuration
public class VersionCtlAutoLoad implements ImportBeanDefinitionRegistrar {

    /**
     * 通过 {@link EnableVersionCtl#value()} 配置的服务消费者所在包.
     */
    private String[] consumerPackages;

    @Autowired
    private VersionCtlInvocationHandler versionCtlInvocationHandler;

    @Override
    public void registerBeanDefinitions(final AnnotationMetadata importingClassMetadata, final BeanDefinitionRegistry registry) {
        final MultiValueMap<String, Object> attributes = importingClassMetadata.getAllAnnotationAttributes(EnableVersionCtl.class.getName());
        consumerPackages = (String[]) attributes.getFirst("value");
        if (consumerPackages==null || consumerPackages.length == 0) {
            throw new VersionException("@EnableVersionCtl consumer packages is empty");
        }

        final ClassPathBeanDefinitionScanner scanner = new VersionCtlServiceScanner(registry);
        scanner.setResourceLoader(AppContext.getCurrentContext().getApplicationContext());
        scanner.scan(consumerPackages);
    }

    @Bean
    public WebMvcConfigurer webMvcConfigurer() {
        return new WebMvcConfigurerAdapter() {
            /**
             * 添加拦截器
             * @param registry
             */
            @Override
            public void addInterceptors(InterceptorRegistry registry) {
                registry.addInterceptor(versionCtlInvocationHandler).addPathPatterns("/**");
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(DefaultVersionBeanFactory.class)
    public DefaultVersionBeanFactory getDefVerFac(){
        return new DefaultVersionBeanFactory();
    }

    @Bean
    @ConditionalOnMissingBean(VersionGetter.class)
    public VersionGetter getVersionGetter(){
        return new VersionGetter();
    }

}
