package com.freemud.framework.boot;

import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

import com.freemud.framework.caching.memory.MemoryCacheOptions;
import com.freemud.framework.spring.SpringStartRunner;

/**
 * @author shaocheng.ding
 */
@Configuration
@EnableConfigurationProperties(MemoryCacheOptions.class)
public class FreemudFrameworkAutoLoad {
    public @Bean
    CommandLineRunner springStartRunner() {
        return new SpringStartRunner();
    }
}
