/*
 * Copyright (c) 2018  www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.firstboot.web;

import cn.freemud.firstboot.service.ProductService;
import cn.freemud.firstboot.vo.ProductCreateReq;
import cn.freemud.firstboot.vo.ProductResp;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@Api
@RestController
@RequestMapping("/product")
@Slf4j
public class ProductController {

    @Autowired
    private ProductService productService;


    @Resource(name = "defaultProductService")
    private ProductService defaultProductService;

    @ApiOperation(value = "根据ID获取产品", notes = "根据ID获取产品")
    @ApiImplicitParam(value = "请求", required = true, dataType = "String", name = "id")
    @GetMapping("/getById")
    public ProductResp getById(String id) {
        return productService.getById(id);
    }

    @ApiOperation(value = "根据ID获取产品", notes = "根据ID获取产品")
    @ApiImplicitParam(value = "请求", required = true, dataType = "String", name = "id")
    @RequestMapping(value = "/getById2", method = RequestMethod.GET)
    public ProductResp getById2(@RequestParam String id) {
        return defaultProductService.getById(id);
    }

    @ApiOperation(value = "创建产品", notes = "创建产品")
    @ApiImplicitParam(value = "请求", required = true, dataType = "ProductCreateReq", name = "req")
    @RequestMapping(value = "/create", method = RequestMethod.POST)
    public ProductResp create(@RequestBody ProductCreateReq req) {
        return productService.create(req);
    }
}
