/*
 * Copyright (c) 2018  www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.firstboot.service.impl;

import cn.freemud.firstboot.dao.ProductDao;
import cn.freemud.firstboot.service.ProductService;
import cn.freemud.firstboot.vo.ProductCreateReq;
import cn.freemud.firstboot.vo.ProductResp;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author qi.xu  2018/11/7 11:16
 */
@Service
@Slf4j
public class DefaultProductService implements ProductService {

    @Autowired
    private ProductDao productDao;

    @Override
    public ProductResp getById(String id) {
        log.info("id = {}", id);
        return productDao.getById(id);
    }


    @Override
    public ProductResp create(ProductCreateReq req) {
        return productDao.create(req);
    }
}
