package cn.freemud.entities.vo;

import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;

@Data
public class ActivityJoinVo {

    @NotEmpty(message = "sessionId 不能为空")
    private String sessionId;

    @NotEmpty(message = "oid 不能为空")
    private String oid;

    @NotEmpty(message = "storeId 不能为空")
    private String storeId;

    @NotNull(message = "activityId 不能为空")
    private Long activityId;

    private String nickName;

    /**
     * 图像
     */
    private String avatarUrl;

    /**
     * 版本号
     */
    private String version;
}
