package cn.freemud.service.mccafe.thirdparty;

import cn.freemud.entities.dto.coupon.BatchQueryActivityInfoRequestDto;
import cn.freemud.entities.dto.coupon.GetAppKeyRequestDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

//测试环境：http://115.159.65.101:8082 生产环境：https://onlinecoupon.sandload.cn
@FeignClient(name = "CARDBINMCCafeCLIENT",url="fff")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CardBinMCCafeClient {
    /**
     * 获取麦咖啡券码密钥
     * @param requestDto
     * @return
     */
    @PostMapping("/mccafe/getAppKey")
    GetAppKeyRequestDto getMCCafeAppKey(GetAppKeyRequestDto requestDto);

    /**
     * 麦咖啡活动信息批量查询
     * @param requestDto
     * @return
     */
    @PostMapping(value = "/mccafe/batchQueryActivityInfo")
    BatchQueryActivityInfoRequestDto batchQueryMCCafeActivityInfo(BatchQueryActivityInfoRequestDto requestDto);


}
