package cn.freemud.service;

import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.utils.SpringBeanUtil;
import com.freemud.application.sdk.api.base.BaseResponse;
import com.freemud.application.sdk.api.log.ApiLog;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.storecenter.request.StoreInfoRequest;
import com.freemud.application.sdk.api.storecenter.request.vo.GetOrgTreeListRequest;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import com.freemud.application.sdk.api.storecenter.response.vo.GetOrgTreeListResponse;
import com.freemud.application.sdk.api.storecenter.service.StoreCenterService;
import com.google.common.base.Joiner;
import org.apache.commons.collections4.CollectionUtils;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: null.java
 * @Package
 * @Description: 公共方法
 * @author: 蓝胖子(Hector)
 * @date: 2019-10-23
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */

public interface CommonService {
    /**
     * 查询门店服务 - 获取组织结构树
     *
     * @param partnerId
     * @param storeCode
     * @return
     */
    default List<String> getOrgIds(String partnerId, String storeCode) {
        GetOrgTreeListRequest request = new GetOrgTreeListRequest();
        request.setPartnerId(partnerId);
        request.setStoreCode(storeCode);
        StoreCenterService storeCenterService = SpringBeanUtil.getBean(StoreCenterService.class);
        BaseResponse<List<String>> orgList = storeCenterService.getOrgList(request, LogThreadLocal.getTrackingNo());
        if (orgList != null && ResponseCodeConstant.RESPONSE_SUCCESS_STR.equals(orgList.getCode())) {
            return orgList.getData();
        }
        return null;
    }

    /**
     * 查询门店服务 - 获取组织code集合
     *
     * @param partnerId
     * @param storeCode
     * @return
     */
    default List<String> getOrgCodes(String partnerId, String storeCode) {
        GetOrgTreeListRequest request = new GetOrgTreeListRequest();
        request.setPartnerId(partnerId);
        request.setStoreCode(storeCode);
        StoreCenterService storeCenterService = SpringBeanUtil.getBean(StoreCenterService.class);
        BaseResponse<GetOrgTreeListResponse> orgList = storeCenterService.getOrgTreeList(request, LogThreadLocal.getTrackingNo());
        if (orgList != null && ResponseCodeConstant.RESPONSE_SUCCESS_STR.equals(orgList.getCode())) {
            List<GetOrgTreeListResponse.OrgList> orgResponseList = orgList.getData().getOrgList();
            if (CollectionUtils.isEmpty(orgResponseList)){
                return null;
            }
            return orgResponseList.stream().map(org -> org.getOrganizationCode()).collect(Collectors.toList());
        }
        return null;
    }

    /**
     * 查询门店服务 - 获取组织结构树
     *
     * @param partnerId
     * @param storeCode
     * @return
     */
    default List<String> getOrgIdsForCoupon(String partnerId, String storeCode) {
        GetOrgTreeListRequest request = new GetOrgTreeListRequest();
        request.setPartnerId(partnerId);
        request.setStoreCode(storeCode);
        StoreCenterService storeCenterService = SpringBeanUtil.getBean(StoreCenterService.class);
        BaseResponse<GetOrgTreeListResponse> orgList = storeCenterService.getOrgTreeList(request, LogThreadLocal.getTrackingNo());
        if (orgList != null && ResponseCodeConstant.RESPONSE_SUCCESS_STR.equals(orgList.getCode())) {
            List<GetOrgTreeListResponse.OrgList> orgResponseList = orgList.getData().getOrgList();
            if (CollectionUtils.isEmpty(orgResponseList)){
                return null;
            }
            return orgResponseList.stream().map(org -> org.getOrganizationId()).collect(Collectors.toList());
        }
        return null;
    }

    default String getOrgIdsAsString(String partnerId, String storeCode) {
        List<String> orgIdList = this.getOrgIds(partnerId, storeCode);
        return CollectionUtils.isNotEmpty(orgIdList) ? Joiner.on(",").join(orgIdList) : "";
    }

    default StoreResponse.BizVO getStoreInfo(String partnerId, String storeCode) {
        StoreInfoRequest request = new StoreInfoRequest();
        request.setPartnerId(partnerId);
        request.setStoreCode(storeCode);
        StoreCenterService storeCenterService = SpringBeanUtil.getBean(StoreCenterService.class);
        StoreResponse storeInfo = storeCenterService.getStoreInfo(request, LogThreadLocal.getTrackingNo());
        if (storeInfo != null) {
            return storeInfo.getBizVO();
        }
        return null;
    }

}
