package cn.freemud.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.function.Function;

@Getter
@AllArgsConstructor
public enum OrderTackCodeFactory {
    
    DEFAULT("99",((Integer code) -> new Integer(code).toString()));

    private String orderClient;
    private Function<Integer,String> generateTackCodeFunc;

    public static OrderTackCodeFactory getByOrderClient(String orderClient){
        return Arrays.stream(OrderTackCodeFactory.values())
                .filter(e -> e.orderClient.equals(orderClient)).findFirst()
                .orElseGet(() -> OrderTackCodeFactory.DEFAULT);
    }
}
