package com.freemud.sdk.api.assortment.order.response.order;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: QueryPartnerRefundCountResponse
 * @Package com.freemud.sdk.api.assortment.order.response.order
 * @Description:
 * @author: pegnfei.liu
 * @date: 2020/10/27
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class QueryPartnerRefundCountResponse {


    private String errcode;
    private String errmsg;
    private PartnerRefundCount data;


    @NoArgsConstructor
    @Data
    public static class PartnerRefundCount {

        /**
         * 商户编号
         */
        private String partnerId;

        /**
         * 门店退款数量
         */
        List<StoreRefundCount> storeRefundCount;

    }

    @NoArgsConstructor
    @Data
    public static class StoreRefundCount {

        /**
         * 门店编号
         */
        private String storeId;

        /**
         * 退款订单数量
         */
        private Long count;

    }

}
