/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderType
 * @Package cn.freemud.enums
 * @Description: 订单状态
 * @author: liming.guo
 * @date: 2018/5/21 14:43
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.sdk.api.assortment.order.enums;

/**
 * 跟新订单状态同步目前
 */
public enum PayStatus {

    NOT_PAY(1, "未支付"),
    HAVE_PAID(2, "已支付"),
    HAVE_REFUND(3, "已退款"),
    HAVE_PART_REFUND(4, "已经部分退款"),
    COMPLETE(5, "完成");


    private Integer code;
    private String desc;

    PayStatus(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static PayStatus getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (PayStatus payStatus : values()) {
            if (payStatus.getCode().equals(code)) {
                return payStatus;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
