package cn.freemud.demo.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.demo.entities.ResponseBuilder;
import cn.freemud.demo.entities.bo.goods.add.BaseAddGoodsBO;
import cn.freemud.demo.entities.dto.AddGoodsBaseResponseVO;

public interface CheckAddGoodsService {

    /**
     * 校验公共参数
     * @param baseRequestDTO
     * @return
     */
    default BaseResponse checkCommParams(BaseAddGoodsBO baseRequestDTO) {
        // TODO checkCommomParams
        return ResponseBuilder.success();
    }

    /**
     * 检验客制化的参数
     * @param baseRequestDTO
     * @return
     */
    default BaseResponse checkCustomParams(BaseAddGoodsBO baseRequestDTO) {
        // TODO checkCustomParams
        return ResponseBuilder.success();
    }


    /**
     * 进行公共的业务校验
     * @param baseRequestDTO
     * @return
     */
    default BaseResponse checkCommBusinessRules(BaseAddGoodsBO baseRequestDTO) {
        // TODO checkCommBusinessRules
        return ResponseBuilder.success();
    }

    /**
     * 进行客制化的业务校验
     * @param baseRequestDTO
     * @return
     */
    default BaseResponse checkCustomBusinessRules(BaseAddGoodsBO baseRequestDTO) {
        // TODO checkCustomBusinessRules
        return ResponseBuilder.success();
    }

    /**
     * 获取购物车信息
     * @param baseRequestDTO
     * @return
     */
    default BaseResponse getShoppingCartInfo(BaseAddGoodsBO baseRequestDTO) {
        // TODO getShoppingCartInfo
        return ResponseBuilder.success();
    }

    /**
     * 公共的计算费用
     * @param baseRequestDTO
     * @return
     */
    default BaseResponse calCommCost(BaseAddGoodsBO baseRequestDTO) {
        // TODO calCommCost
        return ResponseBuilder.success();
    }

    /**
     * 进行客制化的计算费用
     * @param baseRequestDTO
     * @return
     */
    default BaseResponse calCustomCost(BaseAddGoodsBO baseRequestDTO) {
        // TODO calCustomCost
        return ResponseBuilder.success();
    }

    /**
     * 公共的计算费用
     * @param baseRequestDTO
     * @return
     */
    default BaseResponse setCommMessage(BaseAddGoodsBO baseRequestDTO) {
        // TODO setCommMessage
        return ResponseBuilder.success();
    }

    /**
     * 进行客制化的计算费用
     * @param baseRequestDTO
     * @return
     */
    default BaseResponse setCustomMessage(BaseAddGoodsBO baseRequestDTO) {
        // TODO setCustomMessage
        return ResponseBuilder.success();
    }



    /**
     * 封装公共返回
     * @param baseRequestDTO
     * @return
     */
    default BaseResponse buildCommResponse(BaseAddGoodsBO baseRequestDTO) {
        // TODO buildCommResponse
        return ResponseBuilder.success();
    }

    /**
     * 封装客制化返回
     * @param baseRequestDTO
     * @return
     */
    default BaseResponse buildCustomResponse(BaseAddGoodsBO baseRequestDTO) {
        // TODO buildCustomResponse
        return ResponseBuilder.success();
    }

}
