package cn.freemud.demo.adapter;

import cn.freemud.demo.entities.bo.goods.add.*;
import cn.freemud.demo.entities.dto.goods.add.AddGoodsRequestDTO;
import cn.freemud.demo.enums.BizTypeEnum;
import cn.freemud.enums.OrderChannelType;
import com.alibaba.fastjson.JSON;
import org.springframework.stereotype.Component;

@Component
public class ServiceBOAdapter {

    public BaseAddGoodsBO convert2AddGoodsBO(String bizType, AddGoodsRequestDTO baseRequestDTO) {
        BaseAddGoodsBO baseAddGoodsBO;
        if (BizTypeEnum.MAIL.getCode().equals(bizType)){
            baseAddGoodsBO = createMallBO(baseRequestDTO);
        } else if (BizTypeEnum.MCOFFEE.getCode().equals(bizType)) {
            baseAddGoodsBO = createMCoffeeBO(baseRequestDTO);
        } else {
            baseAddGoodsBO = createPlatformBO(baseRequestDTO);
        }
        return baseAddGoodsBO;
    }

    public BaseAddGoodsVO convert2AddGoodsVO(String bizType, BaseAddGoodsBO baseAddGoodsBO) {
        BaseAddGoodsVO baseAddGoodsVO;
        if (BizTypeEnum.MAIL.getCode().equals(bizType)){
            baseAddGoodsVO = createMallBO(baseAddGoodsBO);
        } else if (BizTypeEnum.MCOFFEE.getCode().equals(bizType)) {
            baseAddGoodsVO = createMCoffeeBO(baseAddGoodsBO);
        } else {
            baseAddGoodsVO = createPlatformBO(baseAddGoodsBO);
        }
        return baseAddGoodsVO;
    }

    private MallAddGoodsBO createPlatformBO(AddGoodsRequestDTO baseRequestDTO) {
        MallAddGoodsBO mallAddGoodsBO = new MallAddGoodsBO();
        return mallAddGoodsBO;
    }

    private MCoffeeAddGoodsBO createMCoffeeBO(AddGoodsRequestDTO baseRequestDTO) {
        MCoffeeAddGoodsBO mCoffeeAddGoodsBO = new MCoffeeAddGoodsBO();
        return mCoffeeAddGoodsBO;
    }

    private BaseAddGoodsBO createMallBO(AddGoodsRequestDTO baseRequestDTO) {
        PlatformAddGoodsBO platformAddGoodsBO = new PlatformAddGoodsBO();
        return platformAddGoodsBO;
    }

    private MallAddGoodsBO createPlatformVO(AddGoodsRequestDTO baseRequestDTO) {
        MallAddGoodsBO mallAddGoodsBO = new MallAddGoodsBO();
        return mallAddGoodsBO;
    }

    private MCoffeeAddGoodsBO createMCoffeeVO(AddGoodsRequestDTO baseRequestDTO) {
        MCoffeeAddGoodsBO mCoffeeAddGoodsBO = new MCoffeeAddGoodsBO();
        return mCoffeeAddGoodsBO;
    }

    private BaseAddGoodsBO createMallVO(AddGoodsRequestDTO baseRequestDTO) {
        PlatformAddGoodsBO platformAddGoodsBO = new PlatformAddGoodsBO();
        return platformAddGoodsBO;
    }

}
