/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CouponService
 * @Package cn.freemud.service
 * @Description:
 * @author: pengfei.liu
 * @date: 2020/11/23
 * @version V1.0
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service.delivery.impl;

import cn.freemud.enums.CreateOrderType;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.service.delivery.DeliveryFactory;
import cn.freemud.service.delivery.DeliveryService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.Objects;

@Service
public class DeliveryFactoryImpl implements DeliveryFactory {

    /**
     * 梯度运费
     */
    @Autowired
    @Qualifier("gradDeliveryService")
    DeliveryService gradDeliveryService;

    /**
     * 固定运费
     */
    @Autowired
    @Qualifier("fixDeliveryService")
    DeliveryService fixDeliveryServiceImpl;

    @Override
    public DeliveryService getCalculateDeliveryAmount(Integer orderType,String receiveId) {

        // 如果订单的收获地址为空，且订单是外卖单，使用固定运费
        if (StringUtils.isBlank(receiveId) && Objects.equals(orderType, CreateOrderType.TAKE_OUT.getCode())) {
            return fixDeliveryServiceImpl;
        }else if(StringUtils.isNotBlank(receiveId)){
            return gradDeliveryService;
        }

        throw new ServiceException(ResponseResult.STORE_DELIVERY_AMOUNT_ERROR);

    }
}
