/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CollageOrderServiceImpl
 * @Package cn.freemud.service.impl
 * @Description:
 * @author: hui.miao
 * @date: 2020/10/11 20:55
 * @version V1.0
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.impl;


import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.CreateOrderVo;
import cn.freemud.enums.OrderMarketType;
import cn.freemud.service.CollageOrderService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class CollageOrderServiceImpl implements CollageOrderService {
    @Autowired
    private OrderServiceImpl orderService;

    @Override
    public BaseResponse create(CreateOrderVo createOrderVo) {
        // 标记订单类型-4 拼单
        createOrderVo.setMarketingType(OrderMarketType.COLLAGE.getIndex());
        return this.orderService.createOrderNew(createOrderVo);
    }
}
