/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CollageOrder
 * @Package cn.freemud.controller
 * @Description:
 * @author: hui.miao
 * @date: 2020/9/28 18:07
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.controller;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.CollageOrderRequestVo;
import cn.freemud.service.impl.CollageOrderServiceImpl;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 拼单订单没有持久化存储对象，仅在Redis中暂存标志位信息
 * 购物车操作过程中需要检测拼单订单状态是否合法（锁定、订单超时等）
 * 暂时将Redis操作的拼单订单接口放在购物车聚合及其SDK中
 */
@RestController
@RequestMapping(value = "/shoppingCart/collage", consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(value = "拼单订单 controller", tags = {"拼单订单管理接口"})
public class CollageOrderController {
    @Autowired
    private CollageOrderServiceImpl collageOrderService;

    @ApiOperation(value = "查询拼单订单", notes = "根据商户ID、门店ID、拼单邀请人用户ID或者当前登录用户sessionId查询拼单订单信息")
    @ApiImplicitParam(value = "请求", required = true, dataType = "CollageOrderRequestVo", name = "CollageOrderRequestVo")
    @ApiAnnotation(logMessage = "getOrder")
    @PostMapping(value = "/getOrder")
    public BaseResponse queryCollageOrder(@Validated @LogParams @RequestBody CollageOrderRequestVo request) {
        return collageOrderService.queryCollageOrder(request);
    }

    @ApiOperation(value = "查询拼单状态", notes = "根据商户ID、门店ID、拼单邀请人用户ID或者当前登录用户sessionId查询拼单状态")
    @ApiImplicitParam(value = "请求", required = true, dataType = "CollageOrderRequestVo", name = "CollageOrderRequestVo")
    @ApiAnnotation(logMessage = "getOrderStatus")
    @PostMapping(value = "/getOrderStatus")
    public BaseResponse queryCollageOrderStatus(@Validated @LogParams @RequestBody CollageOrderRequestVo request) {
        return collageOrderService.queryCollageOrderStatus(request);
    }

    @ApiOperation(value = "创建拼单订单", notes = "根据商户ID、门店ID、当前登录用户sessionId创建拼单订单信息")
    @ApiImplicitParam(value = "请求", required = true, dataType = "CollageOrderRequestVo", name = "CollageOrderRequestVo")
    @ApiAnnotation(logMessage = "createOrder")
    @PostMapping(value = "/createOrder")
    public BaseResponse createOrder(@Validated @LogParams @RequestBody CollageOrderRequestVo request) {
        return collageOrderService.createCollageOrder(request);
    }

    @ApiOperation(value = "取消拼单订单", notes = "根据商户ID、门店ID、当前登录用户sessionId取消拼单订单，并删除相关拼单信息")
    @ApiImplicitParam(value = "请求", required = true, dataType = "CollageOrderRequestVo", name = "CollageOrderRequestVo")
    @ApiAnnotation(logMessage = "cancelOrder")
    @PostMapping(value = "/cancelOrder")
    public BaseResponse cancelCollageOrder(@Validated @LogParams @RequestBody CollageOrderRequestVo request) {
        return collageOrderService.cancelCollageOrder(request);
    }

    @ApiOperation(value = "清除拼单订单", notes = "根据商户ID、门店ID、当前登录用户sessionId删除相关拼单信息")
    @ApiImplicitParam(value = "请求", required = true, dataType = "CollageOrderRequestVo", name = "CollageOrderRequestVo")
    @ApiAnnotation(logMessage = "clearOrder")
    @PostMapping(value = "/clearOrder")
    public BaseResponse clearCollageOrder(@Validated @LogParams @RequestBody CollageOrderRequestVo request) {
        return collageOrderService.clearCollageOrder(request);
    }

    @ApiOperation(value = "更新拼单订单", notes = "根据商户ID、门店ID、当前登录用户sessionId更新相关拼单信息")
    @ApiImplicitParam(value = "请求", required = true, dataType = "CollageOrderRequestVo", name = "CollageOrderRequestVo")
    @ApiAnnotation(logMessage = "updateOrder")
    @PostMapping(value = "/updateOrder")
    public BaseResponse updateCollageOrder(@Validated @LogParams @RequestBody CollageOrderRequestVo request) {
        return collageOrderService.updateCollageOrder(request);
    }

    @ApiOperation(value = "锁定拼单订单", notes = "根据商户ID、门店ID、当前登录用户sessionId锁定拼单订单")
    @ApiImplicitParam(value = "请求", required = true, dataType = "CollageOrderRequestVo", name = "CollageOrderRequestVo")
    @ApiAnnotation(logMessage = "lockOrder")
    @PostMapping(value = "/lockOrder")
    public BaseResponse lockCollageOrder(@Validated @LogParams @RequestBody CollageOrderRequestVo request) {
        return collageOrderService.lockCollageOrder(request);
    }

    @ApiOperation(value = "解锁拼单订单", notes = "根据商户ID、门店ID、当前登录用户sessionId解锁拼单订单")
    @ApiImplicitParam(value = "请求", required = true, dataType = "CollageOrderRequestVo", name = "CollageOrderRequestVo")
    @ApiAnnotation(logMessage = "unlockOrder")
    @PostMapping(value = "/unlockOrder")
    public BaseResponse unlockCollageOrder(@Validated @LogParams @RequestBody CollageOrderRequestVo request) {
        return collageOrderService.unlockCollageOrder(request);
    }

    @ApiOperation(value = "拼单参与人加购完毕", notes = "根据商户ID、门店ID、拼单发起人userId、当前登录用户sessionId修改加购状态为加购完毕")
    @ApiImplicitParam(value = "请求", required = true, dataType = "CollageOrderRequestVo", name = "CollageOrderRequestVo")
    @ApiAnnotation(logMessage = "readyMemberState")
    @PostMapping(value = "/readyMemberState")
    public BaseResponse readyMemberState(@Validated @LogParams @RequestBody CollageOrderRequestVo request) {
        return collageOrderService.readyCollageMemberState(request);
    }

    @ApiOperation(value = "拼单参与人继续加购", notes = "根据商户ID、门店ID、拼单发起人userId、当前登录用户sessionId修改加购状态为继续加购")
    @ApiImplicitParam(value = "请求", required = true, dataType = "CollageOrderRequestVo", name = "CollageOrderRequestVo")
    @ApiAnnotation(logMessage = "shoppingMemberState")
    @PostMapping(value = "/shoppingMemberState")
    public BaseResponse shoppingMemberState(@Validated @LogParams @RequestBody CollageOrderRequestVo request) {
        return collageOrderService.shoppingCollageMemberState(request);
    }

    @ApiOperation(value = "加入拼单订单", notes = "加入拼单订单")
    @ApiImplicitParam(value = "请求", required = true, dataType = "CollageOrderRequestVo", name = "CollageOrderRequestVo")
    @ApiAnnotation(logMessage = "addOrder")
    @PostMapping(value = "/addOrder")
    public BaseResponse addOrder(@Validated @LogParams @RequestBody CollageOrderRequestVo request) {
        return collageOrderService.addCollageOrder(request);
    }

    @ApiOperation(value = "退出拼单订单", notes = "退出拼单订单")
    @ApiImplicitParam(value = "请求", required = true, dataType = "CollageOrderRequestVo", name = "CollageOrderRequestVo")
    @ApiAnnotation(logMessage = "outOfOrder")
    @PostMapping(value = "/outOfOrder")
    public BaseResponse outOfOrder(@Validated @LogParams @RequestBody CollageOrderRequestVo request) {
        return collageOrderService.outOfOrder(request);
    }

    @ApiOperation(value = "移除拼单人员", notes = "移除拼单人员")
    @ApiImplicitParam(value = "请求", required = true, dataType = "CollageOrderRequestVo", name = "CollageOrderRequestVo")
    @ApiAnnotation(logMessage = "removeMember")
    @PostMapping(value = "/removeMember")
    public BaseResponse removeMember(@Validated @LogParams @RequestBody CollageOrderRequestVo request) {
        return collageOrderService.removeMember(request);
    }
}
