/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: liming.guo
 * @date: 2018/8/10 16:06
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.management.thirdparty;


import cn.freemud.management.annotations.LogIgnoreFeign;
import cn.freemud.management.constant.ResponseCodeConstant;
import cn.freemud.management.constant.ResponseCodeKeyConstant;
import cn.freemud.management.entities.dto.request.BatchOrderRefundV2Request;
import cn.freemud.management.entities.dto.request.pay.AgentPayQueryReq;
import cn.freemud.management.entities.dto.request.pay.AgentPayRefundReq;
import cn.freemud.management.entities.dto.response.pay.AgentPayQueryResp;
import cn.freemud.management.entities.dto.response.pay.AgentPayRefundResp;
import cn.freemud.management.entities.dto.response.pay.PayBatchRefundResponse;
import com.freemud.sdk.api.assortment.order.request.order.MultiOrderRefundRequest;
import com.freemud.sdk.api.assortment.order.response.order.MultiOrderRefundResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "multi-pay-center-api", url = "${saas.paymentcenter.application.api.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface MulitiPaymentClient {

    /**
     * 混合支付退款接口
     */
    @PostMapping("/payment/application/refund")
    @LogIgnoreFeign(excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR}, messageFieldName = ResponseCodeKeyConstant.MSG, printLog = true)
    MultiOrderRefundResponse paymentApplicationRefund(MultiOrderRefundRequest multiOrderRefundRequest, @RequestHeader("partnerId") String partnerId);

    /**
     * 批量支付退款
     */
    @PostMapping("/payment/application/batch/refund")
    @LogIgnoreFeign(excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR}, messageFieldName = ResponseCodeKeyConstant.MSG, printLog = true)
    PayBatchRefundResponse batchRefund(BatchOrderRefundV2Request batchOrderRefundV2Request);


    /**
     * 代付退款
     */
    @PostMapping("/payment/application/agentRefund")
    @LogIgnoreFeign(excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR}, messageFieldName = ResponseCodeKeyConstant.MSG, printLog = true)
    AgentPayRefundResp agentPayRefund(AgentPayRefundReq req);

    /**
     * 代付查询
     */
    @PostMapping("/payment/application/agentQuery")
    @LogIgnoreFeign(excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR}, messageFieldName = ResponseCodeKeyConstant.MSG, printLog = true)
    AgentPayQueryResp agentPayQuery(AgentPayQueryReq req);
}
