package cn.freemud.manager;

import cn.freemud.entities.db.OpenPlatformPartnerStoreDeliveryConfig;
import cn.freemud.manager.dao.OpenPlatformIappPartnerStoreDeliveryConfigDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;


/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: OpenPlatformPartnerStoreDeliveryConfigManager
 * @Package cn.freemud.manager
 * @Description: 简单描述下这个类是做什么用的
 * @author: zhenghuan.yang
 * @date: 2018/7/30 15:30
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Component
public class OpenPlatformPartnerStoreDeliveryConfigManager {


    @Autowired
    private OpenPlatformIappPartnerStoreDeliveryConfigDao deliveryConfigDao;


    public void addDeliveryConfig(OpenPlatformPartnerStoreDeliveryConfig deliveryConfig) {
        deliveryConfig.setGmtCreated(new Date());
        deliveryConfig.setGmtModified(new Date());
        deliveryConfigDao.insert(deliveryConfig);
    }

    public OpenPlatformPartnerStoreDeliveryConfig findByPartnerIdAndStoreCode(String partnerId, String storeCode) {
        OpenPlatformPartnerStoreDeliveryConfig deliveryConfig = new OpenPlatformPartnerStoreDeliveryConfig();
        deliveryConfig.setPartnerId(partnerId);
        deliveryConfig.setStoreId(storeCode);
        return deliveryConfigDao.selectOne(deliveryConfig);
    }

    public boolean updateStoreDeliveryConfig(OpenPlatformPartnerStoreDeliveryConfig deliveryConfig) {
        deliveryConfigDao.updateByPrimaryKeySelective(deliveryConfig);
        return true;
    }


}
