package cn.freemud.management.adapter;

import cn.freemud.management.enums.MessageCenterCmdType;
import cn.freemud.management.enums.OperateType;
import cn.freemud.management.enums.OrderStatus;
import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtInfoDto;
import com.freemud.application.sdk.api.structure.request.PushMessageNoticeDto;
import com.freemud.sdk.api.assortment.message.enums.MessageEventType;
import com.freemud.sdk.api.assortment.message.request.MessagePushOrderTemplateRequest;
import com.freemud.sdk.api.assortment.message.request.MessageTemplateRequest;
import com.freemud.sdk.api.assortment.order.adapter.OrderSdkAdapter;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessagePushAdapter {
    @Autowired
    private OrderSdkAdapter orderSdkAdapter;

    public PushMessageNoticeDto convent2PushMessageNoticeDto(Integer targetType, String partnerId,
                                                             String storeId, String userId, String oid, Integer deliveryStatus, Integer cmdType) {
        PushMessageNoticeDto pushMessageNoticeDto = new PushMessageNoticeDto();
        pushMessageNoticeDto.setPartnerId(partnerId);
        pushMessageNoticeDto.setStoreId(storeId);
        pushMessageNoticeDto.setTargetId(userId);
        pushMessageNoticeDto.setTargetType(targetType);
        pushMessageNoticeDto.setCmd(cmdType);
        pushMessageNoticeDto.setTtl(0);
        pushMessageNoticeDto.setVer("1");
        PushMessageNoticeDto.Message message = new PushMessageNoticeDto.Message();
        message.setType(1);
        if (targetType == 2) {
            PushMessageNoticeDto.Message.Content content = new PushMessageNoticeDto.Message.Content();
            content.setOid(oid);
            content.setDeliveryStatus(deliveryStatus);
            message.setContent(content);
        }
        pushMessageNoticeDto.setData(JSONObject.toJSONString(message));
        return pushMessageNoticeDto;
    }

    public PushMessageNoticeDto convent2PushMessageNoticeDto1(OrderBeanV1 order, OperateType opType) {
        PushMessageNoticeDto pushMessageNoticeDto = new PushMessageNoticeDto();
        pushMessageNoticeDto.setPartnerId(order.getCompanyId());
        pushMessageNoticeDto.setStoreId(order.getShopId());
        pushMessageNoticeDto.setTargetId(null);
        pushMessageNoticeDto.setTargetType(2);
        pushMessageNoticeDto.setCmd(MessageCenterCmdType.JIEDAN_DAYIN_TIXING.getCmd());
        pushMessageNoticeDto.setTtl(0);
        pushMessageNoticeDto.setVer("1");
        PushMessageNoticeDto.Message message = new PushMessageNoticeDto.Message();
        message.setType(1);
        PushMessageNoticeDto.Message.Content content = new PushMessageNoticeDto.Message.Content();
        content.setOid(order.getOid());
        OrderExtInfoDto extInfo = JSONObject.parseObject(order.getExtInfo(), OrderExtInfoDto.class);
        if (extInfo != null) {
            content.setFromAppId(extInfo.getFromAppId());
        }
        content.setOrderClient(orderSdkAdapter.getNewOrderClient(order.getSource()));
        content.setPickUpGoodsNo(order.getOtherCode());
        content.setUserId(order.getUserId());
        Integer orderStatus = order.getStatus();
        switch (opType) {
            case ORDER_CONFIRM:
                orderStatus = OrderStatus.RECEIPT.getCode();
                break;
            case ORDER_DONE:
                orderStatus = OrderStatus.COMPLETE_MAKE.getCode();
                break;
            case ORDER_SEND:
                orderStatus = OrderStatus.DISTRIBUTION.getCode();
                break;
            case ORDER_AFFIRM:
                orderStatus = OrderStatus.COMPLETE.getCode();
                break;
            case ORDER_REJECT:
            case ORDER_AGREE_REFUND:
                orderStatus = OrderStatus.CANCEL.getCode();
                break;
            case ORDER_REJECT_REFUND:
                break;
            default:
        }

        content.setOrderState(orderStatus);
        message.setContent(content);
        pushMessageNoticeDto.setData(JSONObject.toJSONString(message));
        return pushMessageNoticeDto;
    }

    public MessageTemplateRequest<MessagePushOrderTemplateRequest> convent2MessageTemplateRequest(OrderBeanV1 order, String reason, OperateType opType) {
        OrderExtInfoDto extInfo = JSONObject.parseObject(order.getExtInfo(), OrderExtInfoDto.class);
        if (extInfo == null) {
            return null;
        }
        MessageTemplateRequest<MessagePushOrderTemplateRequest> messageTemplateRequest = new MessageTemplateRequest<>();
        messageTemplateRequest.setAppId(extInfo.getAppid());
        messageTemplateRequest.setPartnerId(order.getCompanyId());
        MessagePushOrderTemplateRequest messagePushOrderTemplateRequest = new MessagePushOrderTemplateRequest();

        String address = order.getAddress();
        if(StringUtils.isNotEmpty(address) ){
            //处理字符串中带双引号
            if(address.contains("\"")){
                address = address.replace("\"","");
            }
            // 微信推送 地址长度限制20字符, 多余截取不要
            address = address.length() > 20 ? address.substring(0, 20) :address;
        }
        messagePushOrderTemplateRequest.setAddress(address);
        messagePushOrderTemplateRequest.setDaySeq(order.getDaySeq());
        messagePushOrderTemplateRequest.setGmtExpect(order.getGmtExpect());
        messagePushOrderTemplateRequest.setShopName(order.getShopName());
        messagePushOrderTemplateRequest.setOpenId(extInfo.getOpenid());
        messagePushOrderTemplateRequest.setGmtCreate(order.getGmtCreate());
        messagePushOrderTemplateRequest.setOrderId(order.getOid());
        messagePushOrderTemplateRequest.setPrepayId(extInfo.getPrepayId());
        messagePushOrderTemplateRequest.setFormId(extInfo.getFormId());
        messagePushOrderTemplateRequest.setOrderType(order.getType());
        messagePushOrderTemplateRequest.setOtherCode(order.getOtherCode());
        messagePushOrderTemplateRequest.setAmount(Double.valueOf(order.getAmount()));
        messagePushOrderTemplateRequest.setReason(reason);
        messageTemplateRequest.setData(messagePushOrderTemplateRequest);

        MessageEventType messageEventType = null;
        switch (opType) {
            case ORDER_REJECT:
                messageEventType = MessageEventType.REJECTORDER;
                break;
            case ORDER_DONE:
                messageEventType = MessageEventType.DONEORDER;
                break;
            case ORDER_SEND:
                //外卖订单送出发微信模板消息
                if (ObjectUtils.equals(1, order.getType())) {
                    messageEventType = MessageEventType.DELIVERYORDER;
                } else {
                    messageEventType = MessageEventType.APPRAISEORDER;
                }
                break;
            case ORDER_AFFIRM:
                messageEventType = MessageEventType.APPRAISEORDER;
                break;
            case ORDER_REJECT_REFUND:
                messageEventType = MessageEventType.REFUNDREJECTORDER;
                break;
            default:
                messageEventType = null;
        }
        messageTemplateRequest.setMessageEventType(messageEventType);
        return messageTemplateRequest;
    }
}
