/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CreateOrderType
 * @Package cn.freemud.enums
 * @Description:
 * @author: liming.guo
 * @date: 2018/7/3 13:35
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.sdk.api.assortment.shoppingcart.constant;

public enum CreateOrderType {

    COLLECT_GOODS(1, "到店自取"),
    TAKE_OUT(2, "外卖"),
    SAASMALL(3, "商城");

    private Integer code;
    private String desc;

    public static CreateOrderType getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (CreateOrderType createOrderType : values()) {
            if (createOrderType.getCode().equals(code)) {
                return createOrderType;
            }
        }
        return null;
    }

    CreateOrderType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
