package cn.freemud.entities.dto.promotion;

import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.Date;

public class ActivitySendCouponVO {
    private Long id;
    /**
     * 赠送券活动号
     */
    @ApiModelProperty(value="赠券活动号", name="activityCode", example="V1234567890", required = true)
    @NotEmpty(message = "不可为空")
    private String activityCode;

    /**
     * 赠送券活动名称
     */
    @ApiModelProperty(value="赠券活动名", name="activityName", example="5元代金券", required = true)
    @NotEmpty(message = "不可为空")
    private String activityName;

    /**
     * 赠送券活动描述
     */
    @ApiModelProperty(value="赠券活动描述", name="activityDesc", example="5元代金券")
    private String activityDesc;

    /**
     * 赠送券活动类型
     */
    @ApiModelProperty(value="赠券活动类型", name="activityType", example="2", required = true)
    @NotNull(message = "不可为空")
    private Integer activityType;
    @ApiModelProperty(value="赠券有效期开始时间", name="validityPeriodStart", example="2019-06-14 00:00:00")
    private Date validityPeriodStart;
    @ApiModelProperty(value="赠券有效期结束时间", name="validityPeriodEnd", example="2019-06-14 23:59:59")
    private Date validityPeriodEnd;

    /**
     * 赠送数量
     */
    @ApiModelProperty(value="赠送数量", name="sendNumber", example="2")
    @Min(1)
    private Integer sendNumber;
    @ApiModelProperty(value="库存", name="stock", example="100")
    private Integer stock;


    public String getActivityCode() {
        return activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getActivityDesc() {
        return activityDesc;
    }

    public void setActivityDesc(String activityDesc) {
        this.activityDesc = activityDesc;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public Integer getSendNumber() {
        return sendNumber;
    }

    public void setSendNumber(Integer sendNumber) {
        this.sendNumber = sendNumber;
    }

    public Date getValidityPeriodStart() {
        return validityPeriodStart;
    }

    public void setValidityPeriodStart(Date validityPeriodStart) {
        this.validityPeriodStart = validityPeriodStart;
    }

    public Date getValidityPeriodEnd() {
        return validityPeriodEnd;
    }

    public void setValidityPeriodEnd(Date validityPeriodEnd) {
        this.validityPeriodEnd = validityPeriodEnd;
    }

    public Integer getStock() {
        return stock;
    }

    public void setStock(Integer stock) {
        this.stock = stock;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}