/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderAccountType
 * @Package cn.freemud.enums
 * @Description:
 * @author: liming.guo
 * @date: 2018/8/7 17:30
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.sdk.api.assortment.order.enums;

public enum TransTypeEnum {

    ACTIVITY(1, "活动"),
    COUPON(2, "优惠券"),
    PRODUCT(3, "商品");
    private Integer code;

    private String desc;

    TransTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static TransTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (TransTypeEnum type : TransTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
