package cn.freemud.service;

import cn.freemud.entities.vo.GetPayConfigVo;
import cn.freemud.entities.vo.GetPaySuccessDataRequest;
import cn.freemud.entities.vo.order.PayConfigVo;
import cn.freemud.entities.vo.order.PaySuccessDataVo;
import cn.freemud.enums.OrderTackCodeFactory;
import cn.freemud.enums.TakeCodeOrderType;
import cn.freemud.manager.OrderTackCodeManager;
import cn.freemud.service.business.impl.OrderBusinessServiceImpl;
import cn.freemud.service.impl.PayServiceImpl;
import com.freemud.application.sdk.api.ordercenter.adapter.OrderCenterSdkAdapter;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

/**
 * @author Clover.z
 * @version 1.0.0
 * @since 1.0.0
 */
@Service
@RequiredArgsConstructor
public class ExposureOrderService {

    private final PayServiceImpl payService;
    private final OrderTackCodeManager orderTackCodeManager;
    private final OrderBusinessServiceImpl orderBusinessService;
    private final OrderCenterSdkAdapter orderCenterSdkAdapter;

    public PayConfigVo getPayConfig(GetPayConfigVo req) {
        PayConfigVo vo = new PayConfigVo();
        vo.setPrincipalName(payService.getPaymentPrincipalName(req.getPartnerId(), req.getAppId()));
        vo.setPayTimeOut(payService.getPartnerPayOvertime(req.getPartnerId()));
        vo.setPayCode(payService.getPayCodeByCondition(req.getAppId(), req.getStoreId(), req.getChannel()));
        return vo;
    }

    public PaySuccessDataVo getPaySuccessData(GetPaySuccessDataRequest reqVo) {
        Integer type = TakeCodeOrderType.getTakeCodeOrderType(reqVo.getOrderType());
        String takeCode = orderTackCodeManager.generateTackCode(type,
                reqVo.getPartnerId(),
                reqVo.getStoreId(),
                null,
                OrderTackCodeFactory.getByOrderClient(reqVo.getOrderClient()).getGenerateTackCodeFunc());

        Integer v1Type = orderCenterSdkAdapter.getOldOrderType(reqVo.getOrderType());
        Integer timeout = orderBusinessService.getPaySuccessTimeout(reqVo.getPartnerId(),
                reqVo.getStoreId(),
                v1Type);
        PaySuccessDataVo vo = new PaySuccessDataVo();
        vo.setTakeCode(takeCode);
        vo.setTimeout(timeout);
        return vo;
    }
}
