/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartInfoRequestVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/21 21:03
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import java.util.List;

@AllArgsConstructor
@NoArgsConstructor
@Data
@Builder
public class ShoppingCartInfoRequestVo {

    private String version;

    /**
     * 购物车版本号（围餐）
     */
    private Integer carVer;

    @NotEmpty(message = "sessionId不能为空")
    private String sessionId;

    @NotEmpty(message = "partnerId不能为空")
    private String partnerId;

    @NotEmpty(message = "shopId不能为空")
    private String shopId;

    @NotEmpty(message = "appId不能为空")
    private String appId;
    /**
     * 是否查询用户优惠券 1-查询用户优惠券 flag=1  用户去结算
     */
    private Integer flag;
    /**
     * 优惠券code
     */
    private String couponCode;
    /**
     * 运费券code
     */
    private String freightCouponCode;
    /**
     * 优惠券对应的活动号
     */
    private String activityCode;
    /**
     * 下单类型 CreateOrderType 自取和外卖
     */
    private Integer orderType;

    /**
     * 到店类型  orderType 传1的时候    如果reachStoreTyp为空转成订单类型4  如果不为空存储4(打包带走)和5（店内就餐）
     */
    private Integer reachStoreType;

    /**
     * 加价购商品
     */
    private List<SendGoods> sendGoods;
    /**
     * 是否使用用户积分
     * 1=不显示积分
     * 2=显示积分但不扣减
     * 3=显示积分且扣减
     */
    private Integer useCustomerScore;
    /**
     * svc 卡支付使用
     */
    private String cardCode;
    /**
     * 会员卡信息
     */
    private BuyMemberCard buyMemberCard;

    /**
     * 渠道类型 OrderChannelType
     */
    private String channelType;

    private String menuType;

    private String receiveId;

    /**
     * 随单购是否购买月享卡
     * 1:不购买，2：月卡续费，3：新购月卡
     */
    private String buyMonthlyCard;

    private String monthlyCardCode;

    /**
     * 麦咖啡-买三赠一券活动号
     */
    private String buyThreeGiveOneActivityCode;

    /**
     * 麦咖啡-买三赠一券默认券号
     */
    private String buyThreeGiveOneCouponCode;

    private List<CreateOrderVo.CouponType> couponTypeList;

    @Data
    public final static class SendGoods {
        /**
         * 商品Id
         */
        @NotNull
        private String goodsId;

        private Long originalPrice;
        /**
         * 商品数量
         */
        @NotNull
        private Integer qty;
    }

    @Data
    public final static class BuyMemberCard {
        /**
         * 付费会员卡ID
         */
        private String paidId;
        /**
         * 规则ID
         */
        private String ruleId;
    }

}
