package cn.freemud.controller.delivery;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.delivery.CallbackUrlRequestDto;
import cn.freemud.service.ThirdDeliveryService;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.6.0
 * @Title: DeliveryController
 * @Description: 简单描述下这个类是做什么用的
 * @author: qin.zhou
 * @date: 2019/6/1119:47
 * @Copyright: ${DATE.YARE} www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Slf4j
@RequestMapping("/order")
@RestController
@Validated
public class DeliveryController {

    @Autowired
    private ThirdDeliveryService deliveryService;

    @ApiAnnotation(logMessage = "配送回调")
    @ApiOperation(value = "配送回调", notes = "配送回调", produces = "application/json")
    @PostMapping("/delivery/callbackUrl")
    public BaseResponse callbackUrl(@Valid @LogParams @RequestBody CallbackUrlRequestDto request) {
        return deliveryService.callbackUrl(request);
    }

}
