/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderRefundDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: liming.guo
 * @date: 2018/6/12 15:29
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@NoArgsConstructor
@Data
public class OrderRefundDto {
    /**
     * ver : 2
     * refund_id : 1911912121
     * operator_id : 00000002
     * reqtype : 62
     * station_id : 1
     * store_id : 99998
     * trans_id : lb_test208801211
     * unifyid : 2343242
     * openid : 324324
     * transactions : [{"fmid":"ZHL1205O1555249403_20170721","refund_count":1}]
     */

    private Integer ver;

    private Long refund_id;

    private String operator_id;

    private Integer reqtype;

    private String station_id;

    private String store_id;

    private String trans_id;

    private String unifyid;
    /**
     * 普通支付模式用
     */
    private String openid;
    /**
     * 用户信息服务商模式支付用
     */
    private String sub_openid;

    private List<TransactionBean> transactions;

    @NoArgsConstructor
    @Data
    public static class TransactionBean {

        /**
         * fmid : ZHL1205O1555249403_20170721
         * refund_count : 1
         */

        private String fmid;

        private Long refund_count;
    }
}
