package cn.freemud.service.mccafe.thirdparty;

import com.freemud.application.sdk.api.couponcenter.offline.response.CouponBaseResponse;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponQueryResponse;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponRedeemResponse;
import cn.freemud.entities.dto.coupon.MCCafeCouponLockRequest;
import cn.freemud.entities.dto.coupon.MCCafeCouponRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "COUPONMCCafe",url="http://coupon-api-gateway-koderover-dev-coupon.api-ingress.sandload.cn")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CouponOfflineMCCafeClient {

    @PostMapping("/mccafe/redeem")
    CouponRedeemResponse redeem(MCCafeCouponRequest mcCafeCouponRequest);

    @PostMapping("/mccafe/cancelRedeem")
    CouponRedeemResponse cancelRedeem(MCCafeCouponRequest mcCafeCouponRequest);

    @PostMapping("/mccafe/query")
    CouponQueryResponse query(MCCafeCouponRequest mcCafeCouponRequest);

    @PostMapping("/mccafe/lock")
    CouponBaseResponse lock(MCCafeCouponLockRequest MCCafeCouponLockRequest);

    @PostMapping("/mccafe/unlock")
    CouponBaseResponse unlock(MCCafeCouponLockRequest MCCafeCouponLockRequest);
}
