package cn.freemud.service.impl

import cn.freemud.adapter.ActivityAdapter
import cn.freemud.adapter.CouponAdapter
import cn.freemud.adapter.ShoppingCartConvertAdapter
import cn.freemud.adapter.StoreItemAdapter
import cn.freemud.base.entity.BaseResponse
import cn.freemud.entities.dto.GetCouponDetailResponseDto
import cn.freemud.entities.dto.ProductBaseResponse
import cn.freemud.entities.dto.ProductInfosDto
import cn.freemud.entities.dto.activity.ActivityQueryResponseDto
import cn.freemud.entities.dto.calculate.ActivityCalculationDiscountResponseDto
import cn.freemud.entities.dto.order.PackAmountConfig
import cn.freemud.entities.dto.product.ValiadShopProductResponse
import cn.freemud.entities.vo.CartGoods
import cn.freemud.entities.vo.GetShoppingCartGoodsApportionRequestVo
import cn.freemud.enums.ShoppingCartPromotionEnum
import cn.freemud.handle.CommonFunctionHandle
import cn.freemud.handle.PromotionCommonMethodHandle
import cn.freemud.service.ActivityService
import cn.freemud.service.CommonService
import cn.freemud.service.active.ActiveFactory
import cn.freemud.service.active.impl.PlatformActiveServiceImpl
import cn.freemud.service.impl.calculate.*
import cn.freemud.service.impl.calculate.promotion.*
import cn.freemud.service.shoppingCart.ShoppingCartRelationFactory
import cn.freemud.service.thirdparty.ActivityClient
import cn.freemud.service.thirdparty.CouponOnlineClient
import cn.freemud.service.thirdparty.CustomerApplicationClient
import cn.freemud.service.thirdparty.ProductClient
import cn.freemud.utils.PromotionFactory
import com.alibaba.fastjson.JSON
import com.alibaba.fastjson.TypeReference
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo
import com.freemud.api.assortment.datamanager.manager.customer.AssortmentCustomerInfoManager
import com.freemud.sdk.api.assortment.shoppingcart.service.impl.ShoppingCartBaseServiceImpl
import org.junit.runner.RunWith
import org.mockito.Mockito
import org.powermock.api.mockito.PowerMockito
import org.powermock.core.classloader.annotations.PrepareForTest
import org.powermock.modules.junit4.PowerMockRunner
import org.powermock.modules.junit4.PowerMockRunnerDelegate
import org.spockframework.runtime.Sputnik
import spock.lang.Specification
/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2022/3/4 16:56
 * @description :  购物车 新算价
 */
@RunWith(PowerMockRunner.class)
@PowerMockRunnerDelegate(Sputnik.class)
@PrepareForTest(PromotionFactory.class)
class ShoppingCartNewDiscountSpock extends Specification {
    def shoppingCartNewServiceImpl = new ShoppingCartNewServiceImpl()
    def calculationSharingValidatorService = new CalculationSharingValidatorService()
    def sharingEquallyService = new CalculationSharingEquallyService()
    def promotionCommonMethodHandle = new PromotionCommonMethodHandle()
    def activityAdapter = new ActivityAdapter()
    def couponAdapter = new CouponAdapter()
    def productServiceImpl = new ProductServiceImpl()
    def shoppingCartConvertAdapter = new ShoppingCartConvertAdapter()
    def sharingDiscountService = new CalculationSharingDiscountService()
    def couponService = new CouponServiceImpl()
    def itemService = new ItemServiceImpl()
    def storeItemAdapter = new StoreItemAdapter()
    def defaultPromotionService = new DefaultPromotionService()
    def couponPromotionService = new CouponPromotionService()
    def buySendPromotionService = new BuySendPromotionService()
    def additionalPromotionService = new AdditionalPromotionService()
    def timeSalePromotionService = new TimeSalePromotionService()
    def setMealService = new SetMealServiceImpl()
    def customerScoreService = new CustomerScoreService()
    def xyDiscountService = new XyDiscountServiceImpl()
    def buyAndGiftsPromotionService = new BuyAndGiftsPromotionService()
    def materialPromotionService = new MaterialPromotionService()
    def fullPromotionService = new FullPromotionService()
    def sharingCartService = new CalculationSharingCartService()
    def assortmentSdkService = new AssortmentSdkService()


//    def assortmentSdkService = PowerMockito.mock(AssortmentSdkService)
    def customerInfoManager = PowerMockito.mock(AssortmentCustomerInfoManager.class)
    def shoppingCartBaseService = PowerMockito.mock(ShoppingCartBaseServiceImpl)
    def productService = PowerMockito.mock(ProductServiceImpl.class)
    def productClient = PowerMockito.mock(ProductClient.class)
    def activityClient = PowerMockito.mock(ActivityClient.class)
    def couponOnlineClient = PowerMockito.mock(CouponOnlineClient.class)
    def commonService = PowerMockito.mock(CommonService.class)
    def activityService = PowerMockito.mock(ActivityService)
    def activeFactory = PowerMockito.mock(ActiveFactory)

    // 组装计算活动参数对象
    def calculationCommonService = new CalculationCommonService()
    def commonFunctionHandle = PowerMockito.mock(CommonFunctionHandle)
    def promotionSharingService = new CouponSharingService()
    def fullSharingService = new FullSharingService()
    def giftSharingService = new GiftSharingService()
    def additionSharingService = new AdditionSharingService()
    def scoreSharingService = new ScoreSharingService()
    def deliverySharingService = new DeliverySharingService()
    def buyOneGiveOneSendService = new BuyOneGiveOneSendService()
    def customScoreClient = PowerMockito.mock(CustomerApplicationClient)
    def shoppingCartRelationFactory = PowerMockito.mock(ShoppingCartRelationFactory)

    void setup() {
        productServiceImpl.shoppingCartConvertAdapter = shoppingCartConvertAdapter
        assortmentSdkService.productServiceImpl = productServiceImpl
        assortmentSdkService.mcCafePartnerId = "1206"
        assortmentSdkService.mcCafeUniversalShopId = "1"
        calculationSharingValidatorService.buyOneGiveOneSendService = buyOneGiveOneSendService
        shoppingCartNewServiceImpl.calculationSharingValidatorService = calculationSharingValidatorService
        shoppingCartNewServiceImpl.customerInfoManager = customerInfoManager
        sharingEquallyService.calculationCommonService = calculationCommonService
        sharingEquallyService.deliverySharingService = deliverySharingService
        sharingEquallyService.giftSharingService = giftSharingService
        sharingEquallyService.additionSharingService = additionSharingService
        sharingEquallyService.scoreSharingService = scoreSharingService
        sharingEquallyService.promotionCommonMethodHandle = promotionCommonMethodHandle

        sharingEquallyService.promotionSharingService = promotionSharingService
        shoppingCartNewServiceImpl.sharingEquallyService = sharingEquallyService
        shoppingCartNewServiceImpl.shoppingCartBaseService = shoppingCartBaseService
        shoppingCartNewServiceImpl.shoppingCartRelationFactory = shoppingCartRelationFactory
        shoppingCartNewServiceImpl.productService = productService
        shoppingCartNewServiceImpl.assortmentSdkService = assortmentSdkService
        shoppingCartNewServiceImpl.activityAdapter = activityAdapter
        shoppingCartNewServiceImpl.couponAdapter = couponAdapter
        shoppingCartNewServiceImpl.couponService = couponService
        shoppingCartNewServiceImpl.commonService = commonService
        shoppingCartNewServiceImpl.sharingCartService = sharingCartService
        // fisherman  测试过程中, 需要测试 新老算价需要自己 控制开关
        shoppingCartNewServiceImpl.newSharing = "{\"type\":1,\"grayList\":\"2581\",\"enable\":true}"
        shoppingCartNewServiceImpl.activityClient = activityClient
        shoppingCartNewServiceImpl.sharingDiscountService = sharingDiscountService
        productServiceImpl.productClient = productClient
        sharingDiscountService.activityClient = activityClient
        sharingDiscountService.couponService = couponService
        sharingDiscountService.commonService = commonService
        sharingDiscountService.activeFactory = activeFactory
        couponService.couponOnlineClient = couponOnlineClient
        couponService.commonService = commonService
        couponService.itemService = itemService
        couponService.storeItemClient = productClient
        itemService.storeItemAdapter = storeItemAdapter
        itemService.storeItemClient = productClient
        fullPromotionService.activityService = activityService
        // mock静态类
        PowerMockito.mockStatic(PromotionFactory.class)

        // 组装计算活动参数对象
        sharingCartService.calculationCommonService = calculationCommonService
        calculationCommonService.commonFunctionHandle = commonFunctionHandle
        sharingCartService.promotionSharingService = promotionSharingService
        promotionSharingService.assortmentSdkService = assortmentSdkService
        sharingCartService.fullSharingService = fullSharingService
        sharingCartService.giftSharingService = giftSharingService
        sharingCartService.additionSharingService = additionSharingService
        sharingCartService.scoreSharingService = scoreSharingService
        sharingCartService.deliverySharingService = deliverySharingService
        sharingCartService.buyOneGiveOneSendService = buyOneGiveOneSendService
        fullSharingService.activityService = activityService
        scoreSharingService.customScoreClient = customScoreClient
    }

    def "测试 getShoppingCartGoods 订单调用购物车获取结算金额  新算价"() {
        given: "参数设置"
        def getShoppingCartGoodsApportionRequestVo = JSON.parseObject("{\"shoppingCartInfoRequestVo\":{\"activityCode\":\"D1639031228000490\",\"buyType\":0,\"couponCode\":\"88709762025965446405\",\"couponCodes\":[{\"activityCode\":\"D1639031228000490\",\"couponCode\":\"88709762025965446405\",\"couponType\":3,\"index\":1}],\"enableSharing\":1,\"flag\":0,\"menuType\":\"saas\",\"orderType\":1,\"partnerId\":\"2690\",\"reachStoreType\":4,\"sessionId\":\"7f19e7a7c3621f3499cc518bcf6bc3052433379a\",\"shopId\":\"QAJIALE001\",\"trackingNo\":\"fdeb19a4881742b9a3b5e0b8d88c8921\",\"useCouponFlag\":1,\"useCustomerScore\":2,\"version\":\"3.0.21.4\"}}"
                , GetShoppingCartGoodsApportionRequestVo.class)
        def premiumExchangeActivity = getShoppingCartGoodsApportionRequestVo.getPremiumExchangeActivity()
        def shoppingCartInfoRequestVo = getShoppingCartGoodsApportionRequestVo.getShoppingCartInfoRequestVo()

        // 用户登录信息,可以不改
        def customerInfoVo = JSON.parseObject("{\"accessToken\":\"\",\"alipayUserId\":\"\",\"appId\":\"wx3f7ca0c75b213380\",\"appSecret\":\"\",\"appsecret\":\"\",\"channel\":\"1\",\"customerId\":\"\",\"devBrand\":\"\",\"devModel\":\"\",\"iappId\":\"7\",\"memberId\":\"3614319825989629832\",\"mobile\":\"17327190802\",\"newMember\":false,\"nickName\":\"SWEET SUGA\",\"openId\":\"o98fP4qjUo7xm-nT-JAaVEk9yBqM\",\"openid\":\"o98fP4qjUo7xm-nT-JAaVEk9yBqM\",\"partnerId\":\"2581\",\"photoUrl\":\"https://thirdwx.qlogo.cn/mmopen/vi_32/zahIlicTNSM0IA0qjOryv6s0SzIhlwW9EpQKvL63GbPhBwficMAibDohDEibSCQU0I5KohibIpp0yL57TWRcVKrRH2A/132\",\"registerTime\":\"2021-02-26 14:10:26\",\"sessionId\":\"eac53a53f8ae62def7f40cb1e47a1bd9791d95a8\",\"sessionKey\":\"GCyyapzbBSM4yXh9AduGOw==\",\"session_key\":\"GCyyapzbBSM4yXh9AduGOw==\",\"storeId\":\"\",\"tableNumber\":\"\",\"thirdPartyMemberID\":\"\",\"thirdPartyPartnerID\":\"\",\"unionId\":\"o7cEm68JPFhbrzqb0a0BcQE-dDVA\",\"wxAppId\":\"wx3f7ca0c75b213380\",\"wxAppid\":\"wx3f7ca0c75b213380\"}"
                , AssortmentCustomerInfoVo.class)

        // 促销算价  promotioncenter/calculateservice/discount/sharing
        def sharingDiscountResponseDto = JSON.parseObject("{\"msg\":\"成功\",\"result\":{\"apportionGoods\":[],\"couponDiscounts\":[],\"discounts\":[{\"activityCode\":\"88709762025965446405\",\"activityName\":\"柚子3折券\",\"discount\":97,\"priority\":60,\"type\":31}],\"distributionFee\":0,\"goods\":[{\"actualGoodsNumber\":1,\"cartGoodType\":0,\"cartGoodsUid\":\"e58094b9-412f-4c46-9278-1d81cd694fb5\",\"discountAmount\":69,\"discounts\":[{\"activityCode\":\"88709762025965446405\",\"activityName\":\"柚子3折券\",\"actualGoodsNumber\":1,\"addOnQuantity\":0,\"discount\":69,\"goodsId\":\"255176569631514924\",\"signleDiscount\":69,\"type\":31}],\"gift\":false,\"goodsId\":\"255176569631514924\",\"goodsQuantity\":1,\"groupCombox\":[{\"goodsId\":\"215806490097850416\",\"goodsQuantity\":1,\"originalPrice\":33}],\"meal\":true,\"nowPrice\":100,\"originalPrice\":100,\"realAmount\":31,\"score\":0,\"smallMaterial\":[{\"discountAmount\":25,\"discounts\":[{\"activityCode\":\"88709762025965446405\",\"activityDesc\":\"柚子3折券\",\"activityName\":\"柚子3折券\",\"actualGoodsNumber\":1,\"addOnQuantity\":0,\"discount\":25,\"goodsId\":\"215806490097850416\",\"signleDiscount\":25,\"type\":31}],\"goodsId\":\"215806490097850416\",\"goodsQuantity\":1,\"originalPrice\":33,\"realAmount\":8,\"type\":2},{\"discountAmount\":1,\"discounts\":[{\"activityCode\":\"88709762025965446405\",\"activityDesc\":\"柚子3折券\",\"activityName\":\"柚子3折券\",\"actualGoodsNumber\":1,\"addOnQuantity\":0,\"discount\":1,\"goodsId\":\"215806824348227645\",\"signleDiscount\":1,\"type\":31}],\"goodsId\":\"215806824348227645\",\"goodsQuantity\":1,\"originalPrice\":2,\"realAmount\":1,\"type\":2},{\"discountAmount\":2,\"discounts\":[{\"activityCode\":\"88709762025965446405\",\"activityDesc\":\"柚子3折券\",\"activityName\":\"柚子3折券\",\"actualGoodsNumber\":1,\"addOnQuantity\":0,\"discount\":2,\"goodsId\":\"215810517496862722\",\"signleDiscount\":2,\"type\":31}],\"goodsId\":\"215810517496862722\",\"goodsQuantity\":1,\"originalPrice\":4,\"realAmount\":2,\"type\":2}]}],\"isScoreLimit\":0,\"nightDistributionFee\":0,\"originalTotalAmount\":139,\"stocks\":[],\"totalAmount\":42,\"totalDiscountAmount\":97,\"v3Promotion\":false},\"statusCode\":\"100\",\"ver\":1}"
                , ActivityCalculationDiscountResponseDto.class)

        // 无效参数,
        def goodList = JSON.parseArray("[]"
                , CartGoods.class)

        def responseDto = JSON.parseObject("{\"details\":[{\"active\":{\"ActiveCode\":\"G1643164091158349\",\"ActiveDesc\":\"\\\"优惠券规则：\\n\\n券有效时间：领取后当日生效，有效期45天（具体以门店营业时间为准）\\n\\n使用范围：全国范围内已上线华莱士官方点餐小程序的华莱士门店（湖南省、湖北省、吉林省、新疆自治区除外，广东省、河北省、安徽省、海南省、北京市部分门店可用）\\n\\n活动规则：\\n1、在券有效期内，可凭本券在“华莱士官方点餐”小程序获得一次鸡米花买一送一权益。\\n2、本代金券仅限在“华莱士官方点餐”小程序上使用，与特价折扣商品不可同享，且不支持任何形式的核销后退款、变现、找零或转让。\\n3、产品规格以门店售卖为准。\\n4、 若因不可抗力因素致使本活动因故无法进行，主办方将在法律允许范围内取消、终止、修改或暂停本活动，且不承担任何违约或赔偿责任，尽管有上述约定，主办方将采取合理行动积极促使活动恢复正常。\\n如有疑问，可联系电话：4008899096。\\\"\\n\",\"ActiveId\":158770339,\"ActiveName\":\"鸡米花买一送一券\",\"AppId\":\"{\\\"apps\\\":[{\\\"appId\\\":\\\"wx3f7ca0c75b213380\\\",\\\"appName\\\":\\\"华莱士官方点餐\\\"},{\\\"appId\\\":\\\"2021002109662866\\\",\\\"appName\\\":\\\"华莱士官方点餐支付宝\\\"}]}\",\"BuyCount\":2,\"CreateDate\":\"2022-01-26 10:28:11\",\"CreateUser\":\"Rena\",\"DailyRedeemTimes\":1,\"EBCode\":\"\",\"Effective\":45,\"EffectiveEnd\":1676476799000,\"EffectiveStart\":1643126400000,\"EndDate\":\"2032-01-24 15:35:23\",\"EndString\":\"2032-01-24 15:35:23\",\"FromDayEffective\":0,\"GiftCount\":1,\"Inventory\":0,\"LastEditDate\":\"2022-03-02 13:53:16\",\"LastEditUser\":\"Rena\",\"LimitType\":1,\"MaxDiscount\":0,\"MaxRedeemTimes\":1,\"MerchantDiscountPrice\":0.00,\"MinAmount\":0.00,\"NoticeType\":0,\"OriginalPrice\":0,\"OtherDiscountPrice\":0.00,\"PartnerID\":2581,\"PlatformDiscountPrice\":0.00,\"RedeemChannel\":\"pickup,delivery\",\"Remain\":0,\"SalePrice\":0,\"StartDate\":\"2022-01-24 15:35:23\",\"StartString\":\"2022-01-24 15:35:23\",\"State\":1,\"Type\":7,\"VoucherFaceValue\":0.00,\"couponKind\":0,\"createType\":0,\"exemptionRule\":21,\"isDonate\":0,\"isMarketingTransfer\":0,\"logo\":\"https://picture.sandload.cn/1643095730650.jpg\",\"productScopeDesc\":\"全场通用\",\"promotionSharing\":0,\"remark\":\"\",\"storeScopeDesc\":\"全门店通用\"},\"activeCode\":\"G1643164091158349\",\"activeOrganizes\":[],\"activeProduct\":[{\"ActiveID\":158770339,\"Amount\":2,\"ID\":101092250,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"210794556366562343\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":210794556366562343},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":102707818,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202721754691430443\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202721754691430443},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":106896658,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"210401734183578909\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":210401734183578909},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":108664259,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201892530732737281\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201892530732737281},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":109930762,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"196181856362935850\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":196181856362935850},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":110136846,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"205739042253494553\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":205739042253494553},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":111281004,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202543005601654827\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202543005601654827},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":114626445,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201893297779668538\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201893297779668538},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":115395628,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202522421465524768\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202522421465524768},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":115820199,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"200624575557483286\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":200624575557483286},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":117240395,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202011967089649173\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202011967089649173},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":117999939,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201889966261817090\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201889966261817090},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":123936211,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201271922131126554\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201271922131126554},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":124066993,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"210802942716994352\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":210802942716994352},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":125896835,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"205705620076274750\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":205705620076274750},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":126390048,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201274763745872130\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201274763745872130},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":126672465,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202529859526748216\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202529859526748216},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":127065845,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202539418023664675\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202539418023664675},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":128117060,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"210243929020483597\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":210243929020483597},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":129635517,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"206150230788338465\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":206150230788338465},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":134711312,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"200463475075688706\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":200463475075688706},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":136288590,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201897415072052794\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201897415072052794},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":137630535,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202540819597675521\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202540819597675521},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":140530255,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201897810603308572\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201897810603308572},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":146050161,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"208982785000576831\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":208982785000576831},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":147751575,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202523893002430477\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202523893002430477},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":148992322,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"218142359735548461\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":218142359735548461},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":156830621,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"196180894333253140\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":196180894333253140},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":160705326,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202538605917268002\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202538605917268002},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":162463116,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202529566968801295\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202529566968801295},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":169597458,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"209226684733332798\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":209226684733332798},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":171307549,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"213420606371245629\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":213420606371245629},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":173136602,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202526680993012751\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202526680993012751},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":176003576,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202526989498738731\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202526989498738731},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":176541223,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202530381634771974\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202530381634771974},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":178377691,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202809932735654450\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202809932735654450},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":180645301,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201276161287901451\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201276161287901451},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":184234583,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"205116588443264314\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":205116588443264314},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":186250294,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"210240193529248544\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":210240193529248544},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":187829982,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202985175152355391\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202985175152355391},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":188803312,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201890450460747316\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201890450460747316},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":189633316,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201904128631273001\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201904128631273001},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":199438172,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"210137445573931030\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":210137445573931030},{\"ActiveID\":158770339,\"Amount\":1,\"ID\":1724328479,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"233056712980957721\",\"Remain\":0,\"exchangePrice\":0.00,\"kgdProductId\":233056712980957721}],\"activeProductSetting\":[],\"activeRedeemTimeIntervalList\":[],\"activeRestrictionVOS\":[],\"code\":\"88709227085491207040\",\"create_time\":\"2022-02-20 15:10:42\",\"limitStoreId\":null,\"lockStatus\":false,\"minAmount\":\"0\",\"sendReason\":\"手动送券，SWEET SUGA，17327190802\",\"status\":0,\"storelimit\":0,\"storeChannelLimit\":0,\"storeLimitLevel\":1,\"title\":\"鸡米花买一送一券\",\"today_available_times\":1,\"total_available_times\":1,\"type\":7,\"valid_ends\":\"2022-04-05 23:59:59\",\"valid_start\":\"2022-02-20 00:00:00\"}],\"errors\":[],\"result\":1,\"statusCode\":0,\"ver\":1}"
                , GetCouponDetailResponseDto.class)


        // 购物车缓存  saas:user:info:cart:goods:2690_1001_3653544968271672251
        // fisherman 注意修改 cartGoodsUid 和促销算价返回一致
        def redisCartBaseResponse = JSON.parseObject("{\"code\":100,\"message\":\"success\",\"result\":[{\"addCartTime\":1666144449119,\"amount\":33,\"canUseCoupon\":1,\"cartGoodsUid\":\"e58094b9-412f-4c46-9278-1d81cd694fb5\",\"categoryName\":\"套餐\",\"classificationForeignName\":\"\",\"classificationId\":\"\",\"classificationName\":\"\",\"createTimeMili\":1666144449119,\"customerCode\":\"isStockLimit001\",\"finalPrice\":100,\"foreignName\":\"\",\"goodsId\":\"255176569631514924\",\"goodsType\":3,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isMonthCardGoods\":0,\"isSunnyCoupon\":0,\"isUseMonthCard\":0,\"linkedId\":\"\",\"materialAmount\":0,\"memberDiscount\":100,\"name\":\"迦勒套餐限制库存\",\"originalAmount\":33,\"originalMaterialAmount\":0,\"originalPrice\":33,\"originalProductType\":7,\"packPrice\":0,\"pic\":\"https://picture.sandload.cn/1666144031098.jpg\",\"productComboList\":[{\"amount\":33,\"customerCode\":\"jrb\",\"extra\":[],\"finalPrice\":33,\"foreignName\":\"\",\"goodsId\":\"215806490097850416\",\"linkedId\":\"\",\"name\":\"柚子的鸡肉棒\",\"originalAmount\":33,\"originalPrice\":33,\"originalProductType\":1,\"pic\":\"https://picture.sandload.cn/1628583566754.jpg\",\"qty\":1,\"skuId\":\"215806490097850416\",\"spuForeignName\":\"\",\"spuName\":\"柚子的鸡肉棒\",\"tax\":0.0,\"taxId\":\"\",\"unit\":\"\",\"weight\":0.0,\"weightType\":false}],\"productGroupList\":[{\"amount\":33,\"customerCode\":\"jrb\",\"extra\":[],\"finalPrice\":33,\"foreignName\":\"\",\"goodsId\":\"215806490097850416\",\"linkedId\":\"\",\"name\":\"柚子的鸡肉棒\",\"originalAmount\":33,\"originalPrice\":33,\"originalProductType\":1,\"pic\":\"https://picture.sandload.cn/1628583566754.jpg\",\"productGroupId\":251946861712302120,\"qty\":1,\"skuId\":\"215806490097850416\",\"spuForeignName\":\"\",\"spuName\":\"柚子的鸡肉棒\",\"tax\":0.0,\"taxId\":\"\",\"unit\":\"\",\"weight\":0.0,\"weightType\":false},{\"amount\":2,\"customerCode\":\"hb\",\"extra\":[],\"finalPrice\":2,\"foreignName\":\"\",\"goodsId\":\"215806824348227645\",\"linkedId\":\"\",\"name\":\"柚子的汉堡\",\"originalAmount\":2,\"originalPrice\":2,\"originalProductType\":1,\"pic\":\"https://picture.sandload.cn/1628583887266.png\",\"productGroupId\":251946861712302120,\"qty\":1,\"skuId\":\"215806824348227645\",\"spuForeignName\":\"\",\"spuName\":\"柚子的汉堡\",\"tax\":0.0,\"taxId\":\"\",\"unit\":\"\",\"weight\":0.0,\"weightType\":false},{\"amount\":4,\"customerCode\":\"gl\",\"extra\":[],\"finalPrice\":4,\"foreignName\":\"\",\"goodsId\":\"215810517496862722\",\"linkedId\":\"\",\"name\":\"柚子的果篮\",\"originalAmount\":40,\"originalPrice\":40,\"originalProductType\":1,\"pic\":\"https://picture.sandload.cn/1628587383665.jpg\",\"productGroupId\":251946861712302120,\"qty\":1,\"skuId\":\"215810517496862722\",\"spuForeignName\":\"\",\"spuName\":\"柚子的果篮\",\"tax\":0.0,\"taxId\":\"\",\"unit\":\"\",\"weight\":0.0,\"weightType\":false}],\"productMaterialList\":[],\"qty\":1,\"riseSell\":1,\"singleOrder\":0,\"skuForeignName\":\"\",\"skuId\":\"255176569631514924\",\"skuName\":\"迦勒套餐限制库存\",\"spuForeignName\":\"\",\"spuId\":\"255176569631514924\",\"spuName\":\"迦勒套餐限制库存\",\"stockLimit\":true,\"subForeignName\":\"\",\"subName\":\"\",\"unit\":\"\",\"weight\":0.0,\"weightType\":false}],\"ver\":\"1.9.26\"}"
                , new TypeReference<BaseResponse<List<com.freemud.sdk.api.assortment.shoppingcart.domain.CartGoods>>>() {})

        def hasRequiredProducts = false

        def platformActiveServiceImpl = new PlatformActiveServiceImpl()

        def packAmountByStoreConfig = new PackAmountConfig()
        packAmountByStoreConfig.setNewPackAmount(1000L)


        // /Shop/ListProductInfoByIdList
        def productInfosDto = JSON.parseObject("{\"data\":{\"count\":2,\"products\":[{\"barcode\":\"\",\"brandId\":\"\",\"brandName\":\"\",\"category\":\"\",\"categoryName\":\"\",\"companyId\":\"2419\",\"customerCode\":\"1026\",\"finalPrice\":23800,\"isSkuProduct\":0,\"labelNames\":[],\"linkedId\":\"\",\"name\":\"东坡烤鸭(只)\",\"originalPrice\":23800,\"packPrice\":1000,\"picture\":\"https://picture.sandload.cn/1643174237586.jpg\",\"pid\":\"170183609423072022\",\"pknumber\":1,\"productAttributeGroupList\":[],\"productBindingCouponTypes\":[],\"productCode\":\"1026\",\"productComboList\":[],\"productGroupList\":[],\"productPictureList\":[{\"sequence\":\"0\",\"type\":\"default\",\"url\":\"https://picture.sandload.cn/1643174237586.jpg\"}],\"productSpecification\":[],\"productionLocation\":\"\",\"remark\":\"\",\"sellTimeList\":[{\"dateStatus\":1,\"endTime\":\"21:00:00\",\"startTime\":\"11:00:00\"},{\"dateStatus\":2,\"endTime\":\"21:00:00\",\"startTime\":\"11:00:00\"},{\"dateStatus\":4,\"endTime\":\"21:00:00\",\"startTime\":\"11:00:00\"},{\"dateStatus\":8,\"endTime\":\"21:00:00\",\"startTime\":\"11:00:00\"},{\"dateStatus\":16,\"endTime\":\"21:00:00\",\"startTime\":\"11:00:00\"},{\"dateStatus\":32,\"endTime\":\"21:00:00\",\"startTime\":\"11:00:00\"},{\"dateStatus\":64,\"endTime\":\"21:00:00\",\"startTime\":\"11:00:00\"}],\"sequence\":0,\"skuList\":[],\"skuSpecValues\":[],\"sourceChannel\":\"\",\"specification\":\"\",\"specificationGroupList\":[],\"specificationList\":[],\"status\":2,\"stock\":9999,\"stockLimit\":2,\"type\":1,\"unit\":\"g\",\"updateStatus\":0,\"valid\":true,\"version\":0},{\"barcode\":\"\",\"brandId\":\"\",\"brandName\":\"\",\"category\":\"\",\"categoryName\":\"\",\"companyId\":\"2419\",\"customerCode\":\"17155\",\"finalPrice\":0,\"isSkuProduct\":0,\"labelNames\":[],\"linkedId\":\"\",\"name\":\"不需要餐具\",\"originalPrice\":0,\"packPrice\":0,\"picture\":\"https://picture.sandload.cn/1588219576180.jpg\",\"pid\":\"173451209882017045\",\"pknumber\":1,\"productAttributeGroupList\":[],\"productBindingCouponTypes\":[],\"productCode\":\"\",\"productComboList\":[],\"productGroupList\":[],\"productPictureList\":[{\"sequence\":\"0\",\"type\":\"default\",\"url\":\"https://picture.sandload.cn/1588219576180.jpg\"}],\"productSpecification\":[],\"productionLocation\":\"\",\"remark\":\"助力环保，从我做起\",\"sellTimeList\":[],\"sequence\":0,\"skuList\":[],\"skuSpecValues\":[],\"sourceChannel\":\"\",\"specification\":\"\",\"specificationGroupList\":[],\"specificationList\":[],\"status\":2,\"stock\":9999,\"stockLimit\":2,\"type\":1,\"unit\":\"\",\"updateStatus\":0,\"valid\":true,\"version\":0}],\"toPosProductIdType\":0},\"errcode\":100,\"errmsg\":\"成功\"}"
                , ProductInfosDto.class)

        //  Shop/ValidateShopProduct
        def valiadProductResponse = JSON.parseObject("{\"data\":{\"failureList\":[],\"successList\":[{\"code\":0,\"productType\":{\"additionalGroupList\":[],\"barcode\":\"\",\"brandId\":\"\",\"brandName\":\"\",\"businessNo\":\"\",\"category\":\"\",\"categoryName\":\"\",\"companyId\":\"2690\",\"customerCode\":\"isStockLimit001\",\"finalPrice\":106,\"foreignName\":\"\",\"isDishware\":0,\"isSkuProduct\":0,\"linkedId\":\"\",\"memberDiscount\":0,\"name\":\"迦勒套餐限制库存\",\"openMemberDiscount\":0,\"originalPrice\":100,\"stockMode\":2,\"packPrice\":0,\"picture\":\"https://picture.sandload.cn/1666144031098.jpg\",\"pid\":\"255176569631514924\",\"productAttributeGroupList\":[],\"productBindingCouponTypes\":[],\"productCode\":\"123123123asdf\",\"productComboList\":[{\"customerCode\":\"jrb\",\"finalPrice\":33,\"foreignProductName\":\"\",\"linkedId\":\"\",\"originalPrice\":33,\"packPrice\":1,\"picture\":\"https://picture.sandload.cn/1628583566754.jpg\",\"productCode\":\"5566\",\"productId\":\"215806490097850416\",\"productName\":\"柚子的鸡肉棒\",\"productType\":1,\"quantity\":1,\"tax\":0.0,\"taxId\":\"\",\"unit\":\"\",\"weight\":0.0,\"weightType\":0}],\"productGroupList\":[{\"allowRepeat\":1,\"groupCode\":\"迦勒套餐0021\",\"groupDetail\":[{\"customerCode\":\"jrb\",\"foreignProductName\":\"\",\"linkedId\":\"\",\"markUpPrice\":33,\"picture\":\"https://picture.sandload.cn/1628583566754.jpg\",\"productCode\":\"5566\",\"productFinalPrice\":33,\"productId\":\"215806490097850416\",\"productName\":\"柚子的鸡肉棒\",\"productPrice\":33,\"productType\":1,\"stockLimit\":2,\"tax\":0.0,\"taxId\":\"\",\"unit\":\"\",\"weight\":0.0,\"weightType\":0},{\"customerCode\":\"hb\",\"foreignProductName\":\"\",\"linkedId\":\"\",\"markUpPrice\":2,\"picture\":\"https://picture.sandload.cn/1628583887266.png\",\"productCode\":\"445533\",\"productFinalPrice\":2,\"productId\":\"215806824348227645\",\"productName\":\"柚子的汉堡\",\"productPrice\":2,\"productType\":1,\"stockLimit\":2,\"tax\":0.0,\"taxId\":\"\",\"unit\":\"\",\"weight\":0.0,\"weightType\":0},{\"customerCode\":\"gl\",\"foreignProductName\":\"\",\"linkedId\":\"\",\"markUpPrice\":4,\"picture\":\"https://picture.sandload.cn/1628587383665.jpg\",\"productCode\":\"776655\",\"productFinalPrice\":40,\"productId\":\"215810517496862722\",\"productName\":\"柚子的果篮\",\"productPrice\":40,\"productType\":1,\"stockLimit\":1,\"tax\":0.0,\"taxId\":\"\",\"unit\":\"\",\"weight\":0.0,\"weightType\":0}],\"linkId\":\"2690\",\"maxNumber\":5,\"minNumber\":3,\"must\":1,\"name\":\"迦勒商品租\",\"options\":\"\",\"pgid\":\"251946861712302120\",\"remark\":\"\",\"total\":0}],\"productPictureList\":[{\"sequence\":\"0\",\"type\":\"default\",\"url\":\"https://picture.sandload.cn/1666144031098.jpg\"}],\"riseSell\":1,\"singleOrder\":0,\"skuList\":[],\"skuSpecValues\":[],\"specification\":\"\",\"status\":2,\"stock\":50,\"stockLimit\":1,\"type\":7,\"unit\":\"\",\"weight\":0.0,\"weightType\":0},\"skuId\":\"255176569631514924\",\"spuId\":\"255176569631514924\",\"uuid\":\"e58094b9-412f-4c46-9278-1d81cd694fb5\"}]},\"errcode\":100,\"errmsg\":\"获取门店必选分类商品成功\"}"
                , new TypeReference<ProductBaseResponse<ValiadShopProductResponse>>() {})

        def activityQueryResponseDto = JSON.parseObject("{\"msg\":\"成功\",\"result\":[],\"statusCode\":\"100\",\"ver\":1}"
                , new TypeReference<ActivityQueryResponseDto>() {})


        and: "调三方反馈参数 为自己的参数对象 "
        assortmentSdkService.getShoppingCart(_, _, _, _, _, shoppingCartBaseService, _) >> goodList
        assortmentSdkService.setNowBuyShoppingCart(_, _, _, _, _, _, _, shoppingCartBaseService, _) >> goodList
        Mockito.when(shoppingCartBaseService.getCartGoodsList(Mockito.any(), Mockito.any())).thenReturn(redisCartBaseResponse)
        Mockito.when(customerInfoManager.getCustomerInfoByObject(Mockito.any())).thenReturn(customerInfoVo)
        Mockito.when(productService.hasRequiredProducts(Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any())).thenReturn(hasRequiredProducts)
//        Mockito.when(assortmentSdkService.checkShoppingCartSdk(Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(),
//                Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any())).thenReturn(checkCartRequest)
        // 新算价接口
        Mockito.when(activityClient.calculationSharingDiscount(Mockito.any())).thenReturn(sharingDiscountResponseDto)
        Mockito.when(commonService.getOrgIdsAsString(Mockito.any(), Mockito.any())).thenReturn(null)
        Mockito.when(commonService.getOrgIdsForCoupon(Mockito.any(), Mockito.any())).thenReturn(["1e906bab-1800-4b00-8e36-29049d7f4efc", "391cec83-2b60-49a9-af2c-d8d6a813ce72", "16dc665e-8e03-41a8-83ae-95e92666d266"])
        Mockito.when(couponOnlineClient.getCouponDetails(Mockito.any())).thenReturn(responseDto)
        Mockito.when(productClient.listProductInfos(Mockito.any())).thenReturn(productInfosDto)
        Mockito.when(productClient.validateShopProduct(Mockito.any())).thenReturn(valiadProductResponse)
        Mockito.when(activityService.queryActivityByType(Mockito.any(), Mockito.any(), Mockito.any())).thenReturn(activityQueryResponseDto)
        Mockito.when(activeFactory.getBuildChooseGoodsService(Mockito.any())).thenReturn(platformActiveServiceImpl)
        Mockito.when(commonFunctionHandle.getPackAmountByStoreConfig(Mockito.any(), Mockito.any(), Mockito.any())).thenReturn(packAmountByStoreConfig)
        and: "静态方法mock"
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.DEFAULT_PROMOTION)).thenReturn(defaultPromotionService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.COUPON_DISCOUNT)).thenReturn(couponPromotionService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.BUY_ONE_SEND)).thenReturn(buySendPromotionService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.ADDITIONAL_BUY)).thenReturn(additionalPromotionService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.TIME_SALE)).thenReturn(timeSalePromotionService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.SET_MEAL)).thenReturn(setMealService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.CUSTOMER_SCORE)).thenReturn(customerScoreService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.XY_DISCOUNT)).thenReturn(xyDiscountService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.BUY_GIFTS)).thenReturn(buyAndGiftsPromotionService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.Material)).thenReturn(materialPromotionService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.FULL_REDUCTION)).thenReturn(fullPromotionService)

        when: "调用方法逻辑"

        //   测试过程中, 需要测试 新老算价需要自己 控制开关
        def response = shoppingCartNewServiceImpl.getShoppingCartGoods(shoppingCartInfoRequestVo, premiumExchangeActivity)

        then: "验证 返回结果"
        with(response) {
            code == "100"
            message == "success"
        }

    }

}
