/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CouponQueryClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: song.cai
 * @date: 2019/2/20 16:42
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service.thirdparty;

import cn.freemud.annotations.IgnoreFeignLogAnnotation;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.dto.GetMemberCouponListRequestDto;
import cn.freemud.entities.dto.GetMemberCouponListResponseDto;
import cn.freemud.entities.dto.coupon.CouponAvailabilityQueryRequest;
import cn.freemud.entities.dto.coupon.CouponAvailabilityQueryResponse;
import cn.freemud.entities.dto.coupon.CouponResponseDTO;
import feign.HeaderMap;
import feign.Headers;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "OPEN-STORE-COUPON-QUERY-SERVICE", url = "${saas.coupon-query-service.feign.url:}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CouponQueryClient {
    /**
     * 会员优惠券列表
     */
    @IgnoreFeignLogAnnotation(logMessage = "getMemberCouponListRequestDto",excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE,messageFieldName=ResponseCodeKeyConstant.MSG)
    @PostMapping(value = "/customerextendservice/coupon/getCoupons")
    GetMemberCouponListResponseDto getMemberCouponListRequestDto(@RequestBody GetMemberCouponListRequestDto getMemberCouponListRequestDto);

    /**
     * 查询并校验券
     * <pre></pre>
     * @param request
     * @return
     */
    @PostMapping(value = "coupon/query/availability", headers = "API-VERSION=2")
    CouponResponseDTO<CouponAvailabilityQueryResponse> availability(CouponAvailabilityQueryRequest request);
}
