package cn.freemud.entities.dto.coupon;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * &copy; All rights Reserved
 *
 * @author wénkǎi.zhāng 2023-12-11
 * @since 1.0
 */
@Data
public class CouponInfoDto {

    /**
     * 券主键ID
     * <p>
     * 冗余字段，方便查询
     */
    private Long id;

    /**
     * 券名称
     */
    private String name;

    /**
     * 券号
     */
    private String code;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 状态
     */
    private Integer state;

    /**
     * 开始时间
     */
    private String startTime;

    /**
     * 结束时间
     */
    private String endTime;

    /**
     * 所有券类型通用的券面值
     * 该字段不为null时，取该字段作为面值，金额单位为分，100代表1元，如果是折扣，60代表6折.如果字段为null，按照老券处理，不同券从不同的地方取值
     */
    private Integer faceValue;

    /**
     * 启用金额
     */
    private Integer minAmount;

    /**
     * 模板ID
     */
    private String templateId;

    /**
     * 模板编号
     */
    private String templateCode;

    /**
     * 券Logo
     */
    private String logo;

    /**
     * 所属门店
     * <p>
     * 发券时指定门店特有
     */
    private String storeId;

    /**
     * 是否优惠同享
     * <p>
     * 0 否 1 是
     */
    private Integer promotionSharing;

    /**
     * 核销次数限制类型
     * <p>
     * 1：不限，2：每日，3：每周，4：每月
     */
    private Integer redeemNumLimitType;

    /**
     * 最大可用次数
     */
    private Integer configMaxRedeemNums;

    /**
     * 每日最大可用次数
     */
    private Integer configDayMaxRedeemNums;

    /**
     * 当前剩余的可用次数
     */
    private Integer leftAvailableNums;

    /**
     * 最大剩余可用次数
     */
    private Integer leftMaxAvailableNums;

    /**
     * 不可用原因
     */
    private String unAvailableReason;

    /**
     * 不可用错误码
     */
    private String unAvailableCode;

    @JsonIgnore
    private boolean hasRedeemNumLimitType = false;

    /**
     * 次数统计周期过期时间
     */
    @JsonIgnore
    private Date redeemCycleExpiredTime;

    /**
     * 周期内已核销次数
     */
    @JsonIgnore
    private Integer redeemCycleNum;

    /**
     * 全局已核销次数
     */
    @JsonIgnore
    private Integer redeemMaxNum;

    /**
     * 券可用的小程序ID
     */
    private List<String> appIds;

    @ApiModelProperty(value = "发码来源类型")
    private Integer sourceOrigin;

    /**
     * 发码来源类型id
     */
    @ApiModelProperty(value = "发码来源类型id", notes = "来源ID最大长度未64位")
    private String sourceOriginId;

    private Integer exemptionRule;

    @ApiModelProperty(value = "活动商品类别描述，买A赠B必传", example = "主食")
    private String activityProductDesc;

    @ApiModelProperty(value = "赠送商品描述，买A赠B必传", example = "小吃")
    private String giftDesc;

    @ApiModelProperty("券主页图片-使用券时，页面的图片")
    private String couponHomePicture;


    @ApiModelProperty("商家实收金额(分)")
    private Integer receivedAmount;
}
