package cn.freemud.entities.dto.coupon;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;

/**
 * &copy; All rights Reserved
 *
 * @author wénkǎi.zhāng 2023-12-08
 * @since 1.0
 */
@Data
public class CouponAvailabilityQueryRequest {
    /**
     * 商户号
     */
    @NotEmpty(message = "商户号不能为空")
    private String partnerId;

    /**
     * 会员ID
     */
    @NotNull(message = "memberId不能为空")
    private String memberId;

    /**
     * 券类型列表
     * <p>
     * 根据类型列表查询指定类型的券，为空则查询全部
     */
    private List<Integer> types;


    /**
     * 所属门店
     */
    @NotNull(message = "门店编号不能为空")
    private String storeId;

    /**
     * 门店所属渠道
     */
    private List<String> storeChannels;

    /**
     * 当前小程序appid
     */
    private String appId;

    /**
     * 核销场景
     */
    private String scene;

    @ApiModelProperty("门店餐段配置")
    private List<MealSectionTimePeriod> mealSectionTimePeriods;


    /**
     * 购物车信息
     */
    @Valid
    private ShoppingCardInfo shoppingCardInfo;

    @Data
    public static class ShoppingCardInfo {

        /**
         * 商品列表
         */
        @Valid
        @Size(min = 1, message = "购物车商品不能为空")
        private List<Product> products;

        /**
         * 总金额
         */
        private Integer totalAmount;

    }

    /**
     * 商品信息
     */
    @Data
    public static class Product {

        /**
         * 商品编号
         * sku
         */
        @NotNull(message = "商品代码不能为空")
        private String productCode;

        /**
         * 券号
         * <p>
         * 如果是商品券、换购券、买M免N则存在券号
         */
        private String couponCode;

        /**
         * 商品原价
         */
        private Integer originalPrice;

        /**
         * 商品优惠价
         */
        private Integer preferentialPrice;
    }

    @Data
    public static class MealSectionTimePeriod {
        @NotNull(message = "餐段类型不能为空")
        private Integer sectionType;

        @ApiModelProperty(value = "餐段开始时间，单位：秒，1代表当天0点0分1秒", required = true, allowableValues = "range[0, 86398]", example = "0")
        @NotNull(message = "餐段开始时间为不能为空")
        @Min(value = 0, message = "餐段结束时间取值范围[0,86398]")
        @Max(value = 86398, message = "餐段结束时间取值范围[0,86398]")
        private Integer beginTime;

        @ApiModelProperty(value = "餐段结束时间，单位：秒，86399代表当天23点59分59秒", required = true, allowableValues = "range[1, 86399]", example = "86399")
        @NotNull(message = "餐段结束时间为不能为空")
        @Min(value = 1, message = "结束时间取值范围[1,86399]")
        @Max(value = 86399, message = "餐段结束时间取值范围[1,86399]")
        private Integer endTime;
    }

}
