/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: AfterSalesOperateReq
 * @Package com.freemud.application.sdk.api.ordercenter.request
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/3 19:54
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.application.sdk.api.ordercenter.request;

import lombok.Data;

import java.util.List;

@Data
public class AfterSalesOperateReq {

    private String partnerId;

    //订单编号",required = true)
    private String orderCode;

    //售后单编号",required = true)
    private String afterSalesCode;

    private Integer orderClient;

    //三平台订单号 与orderCode二选一,例如百度、饿了么、美团")
    private String thirdOrderCode;

    /**
     * 退款流水号
     */
    private String afterSerialNo;

    //同意审核原因
    private String adultRemark;

    /**
     * 拒绝退款后订单下个状态到下下个状态自动扭转时间(超时完成时间)
     */
    private Integer timeout;

    //操作人
    private String operator;

    /**
     * 操作来源客户端 1:POS插件 2:小助手 3:开放平台 4:自动任务 5:用户端 6:系统 7:万象 8:太一
     */
    private Integer operationClient;

    /**
     * 售后退款状态 0:未定义（存量数据） 1:未退款 2:退款中 3:退款失败 4:已退款
     */
    private Integer refundState;

    /**
     * 对退款明细的记录
     */
    private List<OrderCancelReq.PayRefundItem> payRefundItemList;

    @Data
    public static class PayRefundItem {
        /**
         * 退款支付渠道
         */
        private Integer payChannelType;
        /**
         * 退款支付渠道名称
         */
        private String payChannelName;
        /**
         * 退款金额
         */
        private Integer amount;
        /**
         * 退款流水编号
         */
        private String refundTradeNo;
        /**
         * 退款时间 单位毫秒
         */
        private Long refundTime;
        /**
         * 退款储值卡卡号（退款渠道为储值卡时，则必须传递)
         */
        private String cardCode;
    }
}
