package com.freemud.application.sdk.api.ordercenter.enums;

public enum PayMethodEnum {

    TZFB("TZFB", "支付宝", 2),
    TYL("TYL", "银联", 13),
    TWX("TWX", "微信", 1),
    TSVC("TSVC", "储值卡", 3),
    TOTHER("TOTHER", "其他支付", 10),
    TYZF("TYZF", "翼支付", 12),
    ;


    private String code;
    private Integer index;
    private String desc;

    PayMethodEnum(String code, String desc, Integer index) {
        this.code = code;
        this.desc = desc;
        this.index = index;
    }

    public static PayMethodEnum getByCode(String code) {
        if (code == null) {
            return null;
        }
        for (PayMethodEnum payStatus : values()) {
            if (payStatus.getCode().equals(code)) {
                return payStatus;
            }
        }
        return null;
    }

    public static Integer getIndexByCode(String code) {
        if (code == null) {
            return null;
        }
        for (PayMethodEnum payStatus : values()) {
            if (payStatus.getCode().equals(code)) {
                return payStatus.getIndex();
            }
        }
        return null;
    }

    public static String getDescByCode(String code) {
        if (code == null) {
            return null;
        }
        for (PayMethodEnum payStatus : values()) {
            if (payStatus.getCode().equals(code)) {
                return payStatus.getDesc();
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getIndex() {
        return index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }
}
