package cn.freemud.management.thirdparty.response.coupon;

import cn.freemud.management.enums.coupon.CouponThirdChannelEnum;
import cn.freemud.management.enums.coupon.CouponThirdTypeEnum;
import cn.freemud.management.enums.coupon.ThirdCouponReportStatusEnum;
import cn.freemud.management.enums.coupon.ThirdCouponReportTypeEnum;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * &copy; All rights Reserved, Designed By www.freemud.cn
 *
 * @author wénkǎi.zhāng 2023-08-24
 * @since 1.0
 */
@Data
public class RedeemReportQueryResponse {

    @ApiModelProperty(value = "核销时间", required = true, example = "2023-08-31 10:50:50")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date redeemTime;

    @ApiModelProperty(value = CouponThirdChannelEnum.DESC, required = true, example = "2")
    private Short channel;
    @ApiModelProperty(value = ThirdCouponReportStatusEnum.DESC, required = true, example = "2")
    private Short redeemStatus;
    @ApiModelProperty(value = ThirdCouponReportTypeEnum.DESC, required = true, example = "2")
    private Short redeemType;

    private Short redeemCouponScene;

    @ApiModelProperty(value = "券核销张数")
    private Integer couponNum;

    @ApiModelProperty(value = "商户号")
    private String partnerId;

    @ApiModelProperty(value = "核销门店id", example = "382349534-83635444-353463426463545")
    private String storeId;

    @ApiModelProperty(value = "核销门店编号", example = "c08222")
    private String storeCode;

    @ApiModelProperty(value = "核销门店名称", example = "xxx门店")
    private String storeName;

    @ApiModelProperty(value = CouponThirdTypeEnum.DESC, required = true, example = "0")
    private Short couponType;

    @ApiModelProperty(value = "三方券号", required = true, example = "876372838748325")
    private String couponCode;

    @ApiModelProperty(value = "券名称", required = true, example = "鱼香肉丝套餐券")
    private String couponName;

    @ApiModelProperty(value = "券优惠金额，单位：分", required = true, example = "1000")
    private Integer discountAmount;

    @ApiModelProperty(value = "订单编号", example = "10002937273295444")
    private String orderCode;

    @ApiModelProperty(value = "三方单号", example = "12345678")
    private String thirdOrderCode;

    @ApiModelProperty(value = "会员 id", example = "12345678")
    private String memberId;
}
