package cn.freemud.management.thirdparty.request.ecology.adapter;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * @author Clover.z
 * @version 1.0.0
 * @since 1.0.0
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CancelRedeemCouponRequest extends BaseRequest {

    @ApiModelProperty(value = "交易流水号", required = true)
    @NotBlank
    private String txn;

    @ApiModelProperty(value = "券撤销非码门店ID", required = true)
    private String storeId;

    @ApiModelProperty(value = "券撤销非码会员ID", required = true)
    private String memberId;

    @ApiModelProperty(value = "撤销券号", required = true)
    private String code;
}
