package cn.freemud.management.thirdparty.request.ecology.adapter;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author Clover.z
 * @version 1.0.0
 * @since 1.0.0
 */
@Data
public class BaseRequest {

    /**
     * 商户号
     */
    @ApiModelProperty(value = "商户号", required = true)
    @NotBlank
    private String partnerId;

    @ApiModelProperty(value = "业务渠道, 1-微信;2-支付宝;5-抖音;10-美团点评;15-饿了么", required = true)
    @NotNull(message = "业务渠道不能为空")
    private Integer channel;

    @ApiModelProperty(value = "操作人")
    private String operator;

}
