package cn.freemud.management.thirdparty.request.coupon;

import cn.freemud.management.enums.coupon.CouponThirdChannelEnum;
import cn.freemud.management.enums.coupon.CouponThirdTypeEnum;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import java.util.Date;

/**
 * &copy; All rights Reserved, Designed By www.freemud.cn
 *
 * @author wénkǎi.zhāng 2023-08-24
 * @since 1.0
 */
@Data
public class RedeemReportQueryRequest {
    @ApiModelProperty(value = "商户号", required = true, example = "1864")
    @NotBlank(message = "商户号不能为空")
    private String partnerId;

    @ApiModelProperty(value = "分页查询页码,默认第1页")
    @Min(value = 1, message = "分页查询页码必须为大于零的整数")
    private int pageNum = 1;

    @ApiModelProperty(value = "分页查询单页数据条数,默认10条")
    @Min(value = 1, message = "分页查询单页数据条数必须为大于零的整数")
    private int pageSize = 10;

    @ApiModelProperty(value = "核销时间（起）", required = true, example = "2023-08-31 23:59:59")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date beginTime;

    @ApiModelProperty(value = "核销时间（止）", required = true, example = "2023-08-31 23:59:59")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    @ApiModelProperty(value = CouponThirdChannelEnum.DESC, example = "2")
    private Short channel;

    @ApiModelProperty(value = "门店id", example = "382349534-83635444-353463426463545")
    private String storeId;

    @ApiModelProperty(value = CouponThirdTypeEnum.DESC, example = "0")
    private Short couponType;

    @ApiModelProperty(value = "三方券号", example = "876372838748325")
    private String couponCode;

    /**
     * 核销场景{0:未知，历史数据;1:订单宝;2:小程序;}
     * @ApiModelProperty(value = ThirdCouponRedeemSceneEnum.DESC, example = "0")
     */
    private Short redeemCouponScene;

    private String orderCode;

    @ApiModelProperty(value = "三方订单号")
    private String thirdOrderCode;

    @ApiModelProperty(value = "是否按核销时间倒序，true：是（默认）；false：正序", notes = "导出报表时建议按正序，防止翻页查询时新记产生导致分页数据错乱")
    private boolean orderByRedeemTimeDesc = true;

}
