package cn.freemud.management.thirdparty.request.coupon;

import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * 冻结券请求参数
 *
 * @author tony
 */
@Data
public class CouponUnFreezeReq {

    @Size(min = 1, max = 20, message = "操作的券信息不能为空且最多支持20张")
    private List<CouponInfo> coupons;

    @NotBlank(message = "商户编号不能为空")
    private String partnerId;


    @Valid
    @Data
    public static class CouponInfo {

        private String memberId;

        @NotBlank(message = "券号不能为空")
        private String code;
    }
}
