package cn.freemud.management.thirdparty.request.coupon;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * &copy; All rights Reserved
 *
 * @author wénkǎi.zhāng 2023-12-27
 * @since 1.0
 */
@Data
public class CodeFreezeReq {
    @Size(min = 1, max = 20, message = "操作的券信息不能为空且最多支持20张")
    private List<CouponInfo> coupons;

    @NotBlank(message = "商户编号不能为空")
    private String partnerId;

    @ApiModelProperty("冻结原因。默认储值卡退款")
    private String reason;


    @Valid
    @Data
    public static class CouponInfo {

        private String memberId;

        @NotBlank(message = "券号不能为空")
        private String code;
    }
}
