package cn.freemud.management.thirdparty.request.coupon;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * 作废券请求参数
 *
 * @author tony
 */
@Data
public class BatchCouponDiscardReq {

    @Size(min = 1, message = "作废的券信息不能为空")
    private List<CouponInfo> coupons;

    @NotBlank(message = "商户编号不能为空")
    private String partnerId;

    @NotBlank(message = "渠道编号不能为空")
    private String providerId;

    @NotBlank(message = "作废原因不能为空")
    private String cancelReason;

    @Valid
    @Data
    public static class CouponInfo {

        @NotBlank(message = "会员ID不能为空")
        private String memberId;

        @NotBlank(message = "券号不能为空")
        private String code;
    }

    @ApiModelProperty("接口版本，=1：不校验券是否属于传入的会员id。>1：校验")
    private int ver = 1;
}
