/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CouponQueryClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: song.cai
 * @date: 2019/2/20 16:42
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.management.thirdparty;

import cn.freemud.management.entities.dto.request.coupon.CodeInfoQueryDto;
import cn.freemud.management.entities.dto.response.coupon.CouponBaseResponse;
import cn.freemud.management.thirdparty.request.coupon.CodeInfoQueryReq;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

@FeignClient(name = "OPEN-STORE-COUPON-QUERY-SERVICE", url = "${saas.coupon-query-service.feign.url:}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CouponQueryClient {
    /**
     * 查询券信息
     * <pre></pre>
     * @param request
     * @return
     */
    @PostMapping("coupon/query/info")
    CouponBaseResponse<List<CodeInfoQueryDto>> queryCodesInfo(CodeInfoQueryReq request);
}
