package cn.freemud.management.thirdparty;

import cn.freemud.management.entities.dto.response.coupon.CouponBaseResponse;
import cn.freemud.management.thirdparty.request.coupon.BatchCouponDiscardReq;
import cn.freemud.management.thirdparty.request.coupon.CodeFreezeReq;
import cn.freemud.management.thirdparty.request.coupon.CouponUnFreezeReq;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

//@IgnoreFeignLogAnnotation
@FeignClient(contextId = "coupon-online-service-management", name = "OPEN-STORE-ONLINE-COUPON-SERVICE", url = "${saas.coupononlineclient.feign.url:}")
public interface CouponOnlineClient {


    /**
     * 批量作废券（包括会员卡包中的券）
     * <pre></pre>
     * @param req
     * @return
     */
    @PostMapping("coupon/standard/discard")
    CouponBaseResponse<Object> batchDiscard(BatchCouponDiscardReq req);

    /**
     * 冻结券，注意该接口入参券号尾号必须相同，券数量最多20
     * <pre></pre>
     * @param req
     * @return
     */
    @PostMapping("/coupon/standard/ops/freeze")
    CouponBaseResponse<Object> freeze(CodeFreezeReq req);

    /**
     * 解冻券，请求券号列表中，所有券号尾号必须一样
     * <pre></pre>
     * @param req
     * @return
     */
    @PostMapping("coupon/standard/ops/unfreeze")
    CouponBaseResponse<Object> unfreeze(CouponUnFreezeReq req);
}
