/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CouponQueryClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: song.cai
 * @date: 2019/2/20 16:42
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.management.thirdparty;

import cn.freemud.management.thirdparty.request.coupon.RedeemReportQueryRequest;
import cn.freemud.management.thirdparty.request.coupon.ReverseThirdCouponRedeemReportReq;
import cn.freemud.management.thirdparty.response.coupon.RedeemReportQueryResponse;
import cn.freemud.management.thirdparty.response.coupon.SaasPageResponse;
import cn.freemud.management.thirdparty.response.coupon.SaasResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "OPEN-STORE-COUPON-BACKSTAGE-SERVICE", url = "${saas.coupon-backstage-service.feign.url:}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CouponBackstageClient {
    /**
     * 查询三方券核销记录列表
     * <pre></pre>
     * @param request
     * @return
     */
    @PostMapping("thirdChannelCoupon/redeemReport/query")
    SaasResponse<SaasPageResponse<RedeemReportQueryResponse>> queryCodesInfo(RedeemReportQueryRequest request);

}
