package cn.freemud.management.service.handle;

import com.freemud.application.sdk.api.ordercenter.enums.OrderType;
import com.freemud.application.sdk.api.ordercenter.request.POSOrderOperationBaseReq;
import com.freemud.application.sdk.api.storecenter.request.StoreInfoRequest;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import com.freemud.application.sdk.api.storecenter.service.StoreCenterService;
import com.freemud.sdk.api.assortment.order.enums.AutoOrderConfigTime;
import com.freemud.sdk.api.assortment.order.enums.StoreDeliveryMethod;
import com.freemud.sdk.api.assortment.order.request.order.BaseQueryOrderRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StoreHandle {

    @Autowired
    private StoreCenterService storeCenterService;

    //saas 实时外卖  预约外卖都是 按3个小时流转
    public POSOrderOperationBaseReq setTimeout(BaseQueryOrderRequest baseQueryOrderRequest, POSOrderOperationBaseReq request) {
        String partnerId = baseQueryOrderRequest.getPartnerId();
        String storeCode = baseQueryOrderRequest.getShopId();
        String trackingNo = baseQueryOrderRequest.getTrackingNo();
        if (StringUtils.isEmpty(storeCode)) {
            return request;
        }
        StoreInfoRequest storeInfoRequest = new StoreInfoRequest();
        storeInfoRequest.setPartnerId(partnerId);
        storeInfoRequest.setStoreCode(storeCode);
        StoreResponse storeResponse = storeCenterService.getStoreInfo(storeInfoRequest, trackingNo);
        if (storeResponse == null || storeResponse.getBizVO() == null) {
            return request;
        }
        StoreResponse.Configuration configuration = storeResponse.getBizVO().getStoreConfig();
        String orderWarnTime = storeResponse.getBizVO().getOrderWarnTime();
        Integer timeout = 0;
        Boolean isTakeOut = false;
        Integer takeOutTimeOut = (null == baseQueryOrderRequest.getTimeout() || baseQueryOrderRequest.getTimeout() == 0) ? 180 : baseQueryOrderRequest.getTimeout();
        //是saas 外卖单 且是三方配送
        if ((OrderType.GENERAL_EXPRESS.equals(baseQueryOrderRequest.getOrderType())
                || OrderType.RESERVED_EXPRESS.equals(baseQueryOrderRequest.getOrderType()))
                && StoreDeliveryMethod.THIRD.getCode().equals(baseQueryOrderRequest.getDeliveryType())) {
            isTakeOut = true;
        }
        //自配送外卖单
        if (configuration != null) {
            //外卖单  店外快递实时-3常规外送   店外快递预约-4预约外送
            // 重要的事情重复三遍 saas 实时外卖  预约外卖都是 按3个小时流转
            if (OrderType.GENERAL_EXPRESS.equals(baseQueryOrderRequest.getOrderType()) || OrderType.RESERVED_EXPRESS.equals(baseQueryOrderRequest.getOrderType())) {
                //deliveryProcessingAfterMinute:自建外卖订单-实时单，商家自配送，门店接单xx分钟后，订单状态变更为配送中;
                //deliveryProcessingBeforeMinute: 自建外卖订单-预约单，商家自配送，预约商家前xx分钟，订单更改为配送中
                if (configuration.getDeliveryProcessingAfterMinute() == null
                        || configuration.getDeliveryProcessingBeforeMinute() == null) {
                    timeout = isTakeOut ? takeOutTimeOut : 120;
                }
                //自配送外卖单接单后自动流程时间
                if (configuration.getDeliveryProcessingAfterMinute() != null && configuration.getDeliveryProcessingAfterMinute() > 0) {
                    timeout = StoreDeliveryMethod.SELF.getCode().equals(baseQueryOrderRequest.getDeliveryType())
                            //? AutoOrderConfigTime.getTime(configuration.getDeliveryProcessingAfterMinute().toString())
                            ? configuration.getDeliveryProcessingAfterMinute()
                            : takeOutTimeOut;
                }
                //预约单
                if (OrderType.RESERVED_EXPRESS.equals(baseQueryOrderRequest.getOrderType())
                        && configuration.getDeliveryProcessingBeforeMinute() != null && configuration.getDeliveryProcessingBeforeMinute() > 0) {
                    timeout = StoreDeliveryMethod.SELF.getCode().equals(baseQueryOrderRequest.getDeliveryType())
                            //? AutoOrderConfigTime.getTime(configuration.getDeliveryProcessingBeforeMinute().toString())
                            ? configuration.getDeliveryProcessingBeforeMinute()
                            : takeOutTimeOut;
                }
            } else {
                //自提、堂食单
                if (StringUtils.isNotEmpty(configuration.getAutoSelfmentionTakeOrderWorkflowFinishTime())) {
                    timeout = AutoOrderConfigTime.getTime(configuration.getAutoSelfmentionTakeOrderWorkflowFinishTime());
                }
                //自提、堂食预约单
                if ((OrderType.RESERVED_DINE_IN.equals(baseQueryOrderRequest.getOrderType()) || OrderType.RESERVED_SELF_PICKUP.equals(baseQueryOrderRequest.getOrderType()))
                        && StringUtils.isNotEmpty(configuration.getAppointAutoSelfmentionTakeOrderWorkflowFinishTime())) {
                    timeout = AutoOrderConfigTime.getTime(configuration.getAppointAutoSelfmentionTakeOrderWorkflowFinishTime());
                }
            }
        } else {
            //门店设置为空 用默认
            timeout = isTakeOut ? takeOutTimeOut : 120;
        }
        //预约单提醒任务，触发放拉单队列
        if (OrderType.RESERVED_EXPRESS.equals(baseQueryOrderRequest.getOrderType())
                || OrderType.RESERVED_DINE_IN.equals(baseQueryOrderRequest.getOrderType())
                || OrderType.RESERVED_SELF_PICKUP.equals(baseQueryOrderRequest.getOrderType())) {
            //外卖预约单
            if (OrderType.RESERVED_EXPRESS.equals(baseQueryOrderRequest.getOrderType()) &&
                    configuration != null && configuration.getDeliveryOrderWarnTime() != null) {
                orderWarnTime = configuration.getDeliveryOrderWarnTime();
            }
            request.setRemindTime(getMinTime(orderWarnTime));
        }
        request.setTimeout(timeout);
        return request;
    }

    public Integer getMinTime(String code) {
        Integer minTime = 0;
        if (StringUtils.isBlank(code)) {
            return minTime;
        }
        switch (code) {
            case "1":
                minTime = 15;
                break;
            case "2":
                minTime = 30;
                break;
            case "3":
                minTime = 45;
                break;
            case "4":
                minTime = 60;
                break;
            case "5":
                minTime = 5;
                break;
            case "6":
                minTime = 10;
                break;
            default:
                minTime = 0;
        }
        return minTime;
    }

}
