package cn.freemud.management.enums.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 渠道类型 与生态应用枚举一致
 *
 * @author Clover.z
 * @version 1.0.0
 * @since 1.0.0
 */
@Getter
@AllArgsConstructor
public enum EcologyChannelTypeEnum {

    /**
     * 微信小程序
     */
    WECHAT(1, "微信小程序", "wechat"),
    /**
     * 支付宝小程序
     */
    ALIPAY(2, "支付宝小程序", "alipay"),
    /**
     * 抖音小程序
     */
    TIKTOK(5, "抖音小程序", "tiktok"),

    /**
     * 美团点评
     */
    MEITUAN(10, "美团点评", "meituan"),

    /**
     * 饿了么
     */
    ELEME(15, "饿了么", "eleme"),
    ;

    private final Integer val;
    private final String desc;
    private final String code;

}
