package cn.freemud.management.enums.coupon;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

/**
 * &copy; Copyright
 *
 * @author box 2023-03-14
 */
@RequiredArgsConstructor
@Getter
public enum CouponThirdTypeEnum {

    /**
     * 券类型, 券类型名称
     */
    UNKNOWN((short) -1, "未知"),
    TAO_CAN((short) 0, "套餐券"),
    DAI_JIN((short) 1, "代金券"),
    TUAN_GOU((short) 2, "团购券"),
    CI_KA((short) 3, "次卡"),


    ;


    /**
     * 三方渠道券类型
     */
    private final Short type;
    /**
     * 券类型名称
     */
    private final String typeName;

    public static final String DESC = "三方券类型枚举{0:套餐券;1:代金券;2:团购券;3:次卡}";

}
