package cn.freemud.management.enums;

/**
 * 状态码
 *
 * @author liming.guo
 * @date 2018/05/10
 */
public enum ResponseResult {
    /**
     * 通用信息返回
     */
    SUCCESS("100", "ok"),
    SYSTEM_ERROR("50001", "系统内部错误"),
    SYSTEM_BUSINESS_ERROR("50002", "系统业务错误"),
    NOT_LOGIN("40001", "用户未登录"),
    PARAMETER_MISSING("40002", "缺少必要参数"),
    OPERATE_TOO_OFTEN("40003", "忙不过来了，请稍后再试"),
    OPERATE_NOT_SUPPORT("40004","操作不支持"),

    /**
     * 用户信息状态码
     */
    SESSION_INVAILD("41000", "用户sessionId已过期"),
    USER_GETPHONE_ERROR("41002", "获取用户手机号失败"),
    USER_SIGNATURE_ERROR("41003", "签名信息错误"),
    USER_REGISTER_ERROR("41004", "用户注册失败"),
    USER_CODE_INVAILD("41005", "无效的code信息"),
    USER_EDIT_MOBILE_ERROR("41007", "修改手机号错误"),
    USER_GETRECEIVEADDRESS_ERROR("41008", "获取收货地址异常"),
    USER_UPDATERECEIVEADDRESS_ERROR("41009", "修改收货地址异常"),
    USER_ADDRECEIVEADDRESS_ERROR("41010", "新增收货地址异常"),
    USER_DELETERECEIVEADDRESS_ERROR("41011", "删除收货地址异常"),
    USER_SVC_CARD_ERROR("41012", "用户卡号异常"),


    /**
     * 验证码 状态码
     */
    SMSCODE_SEND_ERROR("42001", "验证码发送失败"),
    SMSCODE_EXIST("42002", "验证码已发送，请注意查收"),
    SMSCODE_ERROR("42003", "验证码错误，请核对后重新输入"),

    /**
     * 门店状态码
     */
    STORE_IMG_NOT_FOUND("43001", "查询图片数据不存在"),
    STORE_ITEM_QUERY_ERROR("43002", "查询门店商品信息失败"),
    STORE_ITEM_NOT_FOUND("43003", "门店商品信息不存在"),
    STORE_NOT_FOUND("43004", "门店不存在"),
    STORE_ITEM_CHECK_VAILD_ERROR("43005", "门店商品校验失败"),
    STORE_ITEM_CHECK_INVAILD("43006", "商品无效"),
    STORE_ITEM_CHECK_DISCOUNT_CHANGE("43010", "商品限购活动已变更"),
    STORE_ITEM_CHECK_CLOSE("43007", "门店已打烊,请预约点餐"),
    STORE_ITEM_STOP_BUSINESS("43010", "门店已停业"),
    STORE_ITEM_NOT_DELIVERY("43008", "门店不支持外卖配送"),
    STORE_ITEM_NOT_IN_DELIVERY_LIMIT_AMOUNT("43009", "订单金额未满足门店起送费"),
    STORE_BUSINESS_HOUR_ERROR("43010", "门店营业时间错误"),
    STORE_NOT_ENABLE_COLLECT_GOODS("43011","门店不支持到店"),
    STORE_NOT_TABLE_INFO("43012","查询桌号失败"),
    STORE_DISCONTENT_DELIVERY_FEE("43013","不满足起送金额"),
    STORE_BIND_MALL_NOT_FOUND("43014","商城门店存在"),
    STORE_INFO_NOT_FOUND("43015","门店信息不存在"),

    /**
     * 购物车状态码
     */
    SHOPPING_CART_GETINFO_ERROR("44001", "查询购物车信息失败"),
    SHOPPING_CART_GETINFO_INVAILD("44002", "购物车信息不存在"),
    SHOPPING_CART_ADD_ERROR("44003", "添加购物车失败"),
    SHOPPING_CART_ADD_INVAILD("44004", "购物车商品不能为空"),
    SHOPPING_CART_UPDATE_ERROR("44005", "更新购物车失败"),
    SHOPPING_CART_CLEAR_ERROR("44006", "清空购车失败"),
    SHOPPING_CART_ACTIVITY_CHANGE("44007", "商品价格有变动，将按照最新活动价格计算哦"),
    SHOPPING_CART_ACTIVITY_UNDERSTOCK("44008", "特价商品库存不足超出部分按照原价购买"),
    SHOPPING_CART_ATTRIBUTE_NOT_EXISTS("44009", "商品属性不存在"),
    SHOPPING_CART_COUPON_NOT_EXIST("44010", "商品券不存在"),
    SHOPPING_CART_SENDGOODS_NOT_EXIST("44011", "加价购商品不存在"),
    SHOPPING_CART_STOCK_NOT_HAVE("44012", "商品库存不足"),

    /**
     * 订单状态码
     */
    ORDER_CREATE_ERROR("45001", "订单创建失败"),
    ORDER_PAYACCESS_ERROR("45002", "订单支付成功确认失败"),
    ORDER_QUERYORDER_ERROR("45003", "查询订单失败"),
    ORDER_DELETE_ERROR("45004", "删除订单失败"),
    ORDER__ERRORREFUND("45005", "订单申请退款失败"),
    ORDER_PAY_GETPRE_MESSAGE_ERROR("45006", "获取预支付信息失败"),
    ORDER_EDIT_ERROR("45007", "修改订单错误"),
    ORDER_COPY_ERROR("45008", "订单复制失败"),
    ORDER_CANCEL_ERROR("45009", "取消订单失败"),
    ORDER_QUERY_QUEUE_INDEX_ERROR("45010", "查询订单排队号失败"),
    ORDER_TAKEMEALTIME_INVAILD("45011", "你的取餐时间穿越了，请重新选择！"),
    ORDER_TAKE_OUT_ADDRESS_INVAILD("45012", "外卖配送地址无效"),
    ORDER_TAKE_OUT_ADDRESS_NOT_DELIVERY("45013", "收货地址超过配送范围"),
    ORDER_QUERY_QUANTITYR_ERROR("45014", "获取当前门店制作中订单失败"),
    ORDER_CREATE_VERIFICATION_ERROR("45015", "限时特价商品核销失败"),
    ORDER_CREATE_TAKEMEALTIME_ERROR("45016", "取餐时间不正确"),
    ORDER_CREATE_TIME_NOT_DELIVERY("45017", "不在外卖配送时间范围内"),
    ORDER_CREATE_FORMID_ISNULL("45018", "0元购formId不能为空"),
    ORDER_GET_PAY_EB_CODE_ERROR("45019", "没有配置支付payEbCode"),
    ORDER_WXAPP_NOT_ENABLE_COLLECT_GOODS("45020","小程序未开通到店自取"),
    PAY_AMOUNT_ERROR("45021","订单支付金额不能小于0"),
    ORDER_NOT_EXIST("45022","订单不存在"),
    ORDER_HAD_EVALUATE("45023","订单已评价"),
    ENCIRCLEORDER_TABLENUMBER_LOCK_ERROR("45025","调用基础服务清台失败"),
    ENCIRCLEORDER_TABLENUMBER_LOCK_USERINFO_ERROR("45026","开台获取用户信息失败"),
    ENCIRCLEORDER_TABLENUMBER_LOCK_FAILED("45027","开台失败"),
    ENCIRCLEORDER_PRE_PAYMENT_LOCK("45028","你的订单正在下单支付,无需再支付,请查看"),
    //ENCIRCLEORDER_PRE_PAYMENT_SUCCESS("45028","订单已支付"),
    ENCIRCLEORDER_PRE_PAYMENT_CLOSE_FAILED("45029","关闭预支付订单失败"),
    ENCIRCLEORDER_UPDATE_ORDER_LOCK("45030","有小伙伴正在下单，请稍后下单"),
    ORDER_COMPAR_PRODUCTS_CHANGE("45031", "订单价格变动,总金额:￥ "),
    CALL_STORE_CHANGE_TABLENUMBER_ERROR("45032","调用门店服务修改桌号状态失败"),
    QUERY_STORE_TABLEWARE_ERROR("45033","查询门店服务餐具错误"),
    CREATE_GROUP_ORDER_ERROR_START("45034","围餐开台创建订单失败"),
    ORDER_CREATE_OPERATION_ERROR("45035","操作类型未定义"),
    ORDER_INFO_NOT_WEIGHT_ERROR("45036","订单中包含未称重商品"),
    ORDER_CODE_EMPTY("45037","订单号不能传空"),
    CREATE_ORDER_CHECK_SESSION_ERROR("45037","sessionId 不能为空"),
    CREATE_ORDER_CHECK_STORE_ERROR("45038","门店ID 不能为空"),
    CREATE_ORDER_CHECK_ORDERTYPE_ERROR("45039","下单类型不能为空"),
    ORDER_PRE_PAYMENT_LOCK("45040","订单正在支付"),
    ORDER_NOT_ALLOW_REFUND("45100", "暂不支持已完成订单申请订单退款"),
    QUERY_TABLESTATUS_ACTIVEFLAG_ERROR("45041","桌号禁用"),
    PREVIEWORDER_UPDATE_ORDERPRICE_ERROR("45042","修改订单失败"),
    UPDATE_ORDER_INFO_ERROR("45043","下单失败"),
    CLEAR_SHOPPING_INFO_ERROR("45044","操作购物车失败"),
    ORDER_CREATE_TABLE_ERROR("45046","开台异常"),
    ORDER_TABLE_BINDING_ERROR("45047","用户未绑定桌号"),//改code与前端有强关联，不可重复
    ENCIRCLEORDER_TABLENUMBER_LOCK("45048","当前桌号正在开台或已开台"),
    ENCIRCLEORDER_PRE_PAYMENT_SUCCESS("45049","订单已支付"),
    CLEAR_SHOPPING_INFO_SYSTEM_ERROR("45048","清空购物车异常"),
    ORDER_PARTNER_ID_NOT_MATCTH("45050","商户不匹配"),
    ORDER_STORE_ID_NOT_MATCTH("45051","门店不匹配"),
    ORDER_REPEAT_DO_COMPLETE("45052", "重复操作，订单已经完成"),
    ORDER_HAS_CANCELED("45053", "订单已经被取消"),
    ORDER_MALL_NOT_MATCH("45054", "非商城订单，无法操作"),
    AFFIRM_ORDER_FAIL("45055", "订单完成失败"),
    ORDER_CANNOT_CONFIRM("45056", "该笔订单不是新订单，不能接单"),
    ORDER_ACCEPT_FAILED("45057", "接单失败"),
    ORDER_ACCEPT_FAILED_CREATE_DELIVERY_FAILED("45058", "创建配送单失败导致接单失败"),
    ORDER_OPERATE_TYPE_NOT_VALIDATE("45059","订单操作类型(operateType)不支持"),
    ORDER_IS_COMPLETE_CAN_NOT_DELIVERY("45060","订单已经完成，不能送出"),
    DELIVERY_SEND_MAKE_UNFINISHED("45061","订单不是制作完成，不能送出"),
    DELIVERY_SEND_REPETITION("45062","重复操作，订单已送出"),
    DELIVERY_SEND_APPLY_REFUND("45063","订单已经申请退款，不能送出"),
    DELIVERY_SEND_STATUS_NOTAKE("45064","订单不是接单，不能送出"),
    DELIVERY_FAIL("45065","送出失败，不能送出"),
    ORDER_DELIVERY_FAILED("45066","订单不是配送状态，不能送达"),
    DONE_FAIL_APPLY_REFUND("45067","订单已经申请退款，不能制作"),
    AFFIRM_FAIL_APPLY_REFUND("45068","订单已经申请退款，不能完成"),
    DONE_FAIL_NOT_ACCEPT("45069","订单不是接单状态，不能制作"),
    DONE_FAIL_REPETITION("45070","重复操作，订单已送出"),
    DONE_ORDER_FAIL("45071", "制作完成更改状态失败"),
    REJECT_FAIL_REPETITION("45072", "重复操作，订单已拒单"),
    REJECT_FAIL_ORDER_IS_DELIVERY("45072", "配送中，不能拒单"),
    REJECT_FAIL_ORDER_IS_COMPLETE("45073", "订单已完成，不能拒单"),
    REJECT_FAIL_ORDER_IS_NOT_NEW("45074", "不是新订单，不能拒单"),
    REJECT_ORDER_FAIL("45075", "拒单失败"),
    AGREE_REFUND_ORDER_FAIL("45076", "同意退款失败"),
    ORDER_REFUND_NOT_APPLY("45077","用户未申请退款"),
    ORDER_HAD_AFFIRM_CAN_NOT_REFUND("45078","当前订单不允许退款，请联系管理员设置"),
    ORDER_REJECT_REFUND_REPETITION("45079","重复操作，订单已拒绝退款"),
    ORDER_REJECT_REFUND_STATUS_NOT("45080","订单不是申请退款中，不能操作"),
    ORDER_REJECT_REFUND_STATUS_END("45081","订单未接单或者已取消，不能操作"),
    REJECT_REFUND_ORDER_FAIL("45082", "拒绝退款失败"),
    ORDER_DELIVERY_CALL_BACK_FAILED("45083", "配送回调失败，为找到对应操作类型"),
    ORDER_UPDATE_PICKUP_FAILED("45084", "更新取餐码失败"),
    ORDER_STATUS_FAILED("45085", "订单状态错误"),
    ORDER_MOVE_FAILED("45086", "三方配送正在进行，不允许操作"),
    AGREE_REFUND_APPLY_ORDER_FAIL("45087", "同意退款申请失败"),
    AGREE_REFUND_APPLY_ORDER_NOT_ALLOW("45088", "商户配置不允许退款，请检查商户配置"),
    PARTNER_ORDER_CANCEL_ERROR("45089", "取消订单失败"),
    ORDER_DELIVERY_EDIT_FAILED("45090", "修改配送状态失败"),
    PARTNER_CAN_NOT_CANCEL_ORDER("45091","订单已部分退款，不能取消"),
    DONE_FAIL_ONE_MINUTE("45092", "平台规定，接单一分钟后才能出餐"),
    REFUND_THIRD_COUPON_TIME_LIMIT("45093", "核销时间超过可冲正期限，撤销核销失败"),
    PARTNER_CAN_NOT_OPERATE("45094","订单已部分退款，请勿重复操作"),

    /**
     * 支付
     */
    PAY_BACKEND_CONFIG_ERROR("58003", "支付交易异常"),
    REFUND_EXCEPTION("58004", "支付退款异常"),
    REFUND_FAIL("58005", "支付退款失败"),
    NOT_SUFFICIENT_FUNDS("8200201", "商户余额不足"),
    CHECK_PARAM_ERROR("58006", "支付退款请求参数校验异常"),
    REFUND_FAIL_WAIT_CALLBACK("58007", "支付退款失败,等待回调补偿中"),
    CAN_NOT_REFUND("58008", "等待品牌操作同意退款"),
    /**
     * 优惠券活动
     */
    COUPON_QUERY_ERROR("46001", "获取优惠券信息失败"),
    COUPON_FULL_ACTIVITY_ERROR("46009", "获取满减信息失败"),
    COUPON_GETINFO_INVAILD("46002", "优惠券信息不存在"),
    COUPON_NOT_REACH_CONDITION("46003", "不满足券的指定消费金额"),
    ACTIVITY_NOT_EXIST("46004", "错过是最美好的相遇！您访问的活动不存在"),
    ACTIVITY_QUERY_ERROR("46005", "活动查询失败"),
    COUPON_GET_ERROR("46006", "优惠券领取失败"),
    ACTIVITY_JOIN_FAIL("46007", "参加活动失败"),
    COUPON_NOT_SHARED("46008", "券不可与其他活动同享"),
    COUPON_NOT_ADD_WEIXIN_CARD("46009", "该优化券不能加入微信卡包"),
    COUPON_SHOP_NOTSUPPORT("46010","优惠券在当前门店不可用"),
    COUPON_ORDER_WAY_ERROR("46011", "您选择得优惠券不适用该点餐方式"),
    COUPON_VERIFICATION_FAIL("46012","优惠券核销失败"),
    COUPON_CALLBACK_FAIL("46013","优惠券移除卡包失败"),
    /**
     * 加价购商品
     */
    PREMIUM_EXCHANGE_ACTIVITY_NOT_EXIST("47001", "换购商品已失效啦，请重新下单"),
    PREMIUM_EXCHANGE_SKU_DEFICIENCY("47002", "您选择的换购商品库存不足，请重新下单"),

    /**
     * 微信卡券
     */
    WEICHAT_SHOP_NOTSUPPORT("48001","当前门店不可用"),
    WEICHAT_NOT_PRODUCTCARD("48002","不是商品券不用加入购物车"),
    WEICHAT_PRODUCT_NOEXIST("48003","商品不存在"),

    /**
     * 配送单
     */
    DELIVERY_QUERY_ERROR("50024","查询配送单失败"),
    DELIVERY_CANCEL_ORDER_ERROR("53012", "取消配送单失败"),
    DELIVERY_CREATE_ORDER_ERROR("53013", "创建配送单失败"),
    DELIVERY_ASSEMBLY_ACK_ERROR("53014", "麦咖啡同步取餐码给配送失败"),
    DELIVERY_ORDER_STOP_ERROR("53015", "配送单停单失败"),

    /**
     * 配送信息
     */
    DELIVERY_INFO_NOT_DELIVERY("60001", "当前地址不可配送"),
    DELIVERY_INFO_ERROR("60002","配送地址不正确"),
    DELIVERY_CREATE_ERROR("60003","运单不足，配送失败"),


    SPELL_GROUP_REFUND_ERROR("80015", "取消拼团失败")

    ;




    private String code;
    private String message;

    /**
     * @param code    状态码
     * @param message 提示信息
     */
    ResponseResult(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static ResponseResult getResponseResult(String code) {
        ResponseResult[] values = ResponseResult.values();
        for (ResponseResult value : values) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }
}
