package cn.freemud.management.enums;

public enum OrderCostType {

    //订单费用类型 1:包装费 2:运费 3:餐盒单价 4:餐盒数量 5:会员卡费用 6:储值卡费用 7:商户小费 8:商户支付运费 9:津贴服务费 11:会员开卡费
    PACKAGE_FEE(1, "包装费"),

    DELIVERY_FEE(2, "运费"),

    OPEN_MEMBER_CARD_FEE(11, "会员卡开卡费"),

    ;


    private int type;

    private String desc;

    OrderCostType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
