package cn.freemud.management.entities.dto.response.pay;

import cn.freemud.management.enums.ResponseResult;
import com.freemud.sdk.api.assortment.order.enums.PayRefundStatus;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: PayRefundResponse
 * @Package cn.freemud.management.entities.dto.response.pay
 * @Description:
 * @author: shuhu.hou
 * @date: 2020/4/24 13:46
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class PayRefundResponse {

    /**
     * 支付退款状态
     */
    private PayRefundStatus payRefundStatus;

    /**
     * 退款序列号
     */
    private String refundId;

    /**
     *  兼容爱马哥退款报错的字段 ,其他场景不会有值
     */
    private ResponseResult result;

    /**
     * 退款失败记录原因
     */
    private String message;

    /**
     * 是否为部分退款订单
     */
    private Boolean partRefund = false;

    /**
     * 退款总额
     */
    private BigDecimal refundAmount;

    /**
     * 对退款明细的记录
     */
    private List<PayRefundItem> payRefundItemList;

    @Data
    public static class PayRefundItem {
        /**
         * 退款支付渠道
         */
        private Integer payChannelType;
        /**
         * 退款支付渠道名称
         */
        private String payChannelName;
        /**
         * 退款金额
         */
        private Integer amount;
        /**
         * 退款流水编号
         */
        private String refundTradeNo;
        /**
         * 退款时间 单位毫秒
         */
        private Long refundTime;
        /**
         * 退款储值卡卡号（退款渠道为储值卡时，则必须传递)
         */
        private String cardCode;
    }
}
